/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.transport.stomp.FrameTranslator;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.StompFrame;

public class LegacyFrameTranslator
implements FrameTranslator {
    public ActiveMQMessage convertFrame(StompFrame command) throws JMSException, ProtocolException {
        ActiveMQMessage msg;
        Map headers = command.getHeaders();
        if (headers.containsKey("content-length")) {
            headers.remove("content-length");
            ActiveMQBytesMessage bm = new ActiveMQBytesMessage();
            bm.writeBytes(command.getContent());
            msg = bm;
        } else {
            ActiveMQTextMessage text = new ActiveMQTextMessage();
            try {
                text.setText(new String(command.getContent(), "UTF-8"));
            }
            catch (Throwable e) {
                throw new ProtocolException("Text could not bet set: " + e, false, e);
            }
            msg = text;
        }
        FrameTranslator.Helper.copyStandardHeadersFromFrameToMessage(command, msg, this);
        return msg;
    }

    public StompFrame convertMessage(ActiveMQMessage message) throws IOException, JMSException {
        StompFrame command = new StompFrame();
        command.setAction("MESSAGE");
        HashMap<String, String> headers = new HashMap<String, String>(25);
        command.setHeaders(headers);
        FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(message, command, this);
        if (message.getDataStructureType() == 28) {
            ActiveMQTextMessage msg = (ActiveMQTextMessage)message.copy();
            command.setContent(msg.getText().getBytes("UTF-8"));
        } else if (message.getDataStructureType() == 24) {
            ActiveMQBytesMessage msg = (ActiveMQBytesMessage)message.copy();
            msg.setReadOnlyBody(true);
            byte[] data = new byte[(int)msg.getBodyLength()];
            msg.readBytes(data);
            headers.put("content-length", "" + data.length);
            command.setContent(data);
        }
        return command;
    }

    public String convertDestination(Destination d) {
        if (d == null) {
            return null;
        }
        ActiveMQDestination amq_d = (ActiveMQDestination)d;
        String p_name = amq_d.getPhysicalName();
        StringBuffer buffer = new StringBuffer();
        if (amq_d.isQueue()) {
            buffer.append("/queue/");
        }
        if (amq_d.isTopic()) {
            buffer.append("/topic/");
        }
        buffer.append(p_name);
        return buffer.toString();
    }

    public ActiveMQDestination convertDestination(String name) throws ProtocolException {
        if (name == null) {
            return null;
        }
        if (name.startsWith("/queue/")) {
            String q_name = name.substring("/queue/".length(), name.length());
            return ActiveMQDestination.createDestination(q_name, (byte)1);
        }
        if (name.startsWith("/topic/")) {
            String t_name = name.substring("/topic/".length(), name.length());
            return ActiveMQDestination.createDestination(t_name, (byte)2);
        }
        throw new ProtocolException("Illegal destination name: [" + name + "] -- ActiveMQ STOMP destinations " + "must begine with /queue/ or /topic/");
    }
}

