/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.Destination;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.test.JmsTopicSendReceiveWithTwoConnectionsTest;

public class CompositeConsumeTest
extends JmsTopicSendReceiveWithTwoConnectionsTest {
    public void testSendReceive() throws Exception {
        this.messages.clear();
        Destination[] destinations = this.getDestinations();
        int destIdx = 0;
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage message = this.session.createTextMessage(this.data[i]);
            if (this.verbose) {
                log.info("About to send a message: " + message + " with text: " + this.data[i]);
            }
            this.producer.send(destinations[destIdx], message);
            if (++destIdx < destinations.length) continue;
            destIdx = 0;
        }
        this.assertMessagesAreReceived();
    }

    protected String getSubject() {
        return this.getPrefix() + "FOO.BAR," + this.getPrefix() + "FOO.X.Y," + this.getPrefix() + "BAR.>";
    }

    protected Destination[] getDestinations() {
        return new Destination[]{new ActiveMQTopic(this.getPrefix() + "FOO.BAR"), new ActiveMQTopic(this.getPrefix() + "BAR.WHATNOT.XYZ"), new ActiveMQTopic(this.getPrefix() + "FOO.X.Y")};
    }

    protected String getPrefix() {
        return super.getSubject() + ".";
    }
}

