/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.test.JmsSendReceiveTestSupport;

public class CompositePublishTest
extends JmsSendReceiveTestSupport {
    protected Connection sendConnection;
    protected Connection receiveConnection;
    protected Session receiveSession;
    protected MessageConsumer[] consumers;
    protected List[] messageLists;

    protected void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = this.createConnectionFactory();
        this.sendConnection = this.createConnection();
        this.sendConnection.start();
        this.receiveConnection = this.createConnection();
        this.receiveConnection.start();
        log.info("Created sendConnection: " + this.sendConnection);
        log.info("Created receiveConnection: " + this.receiveConnection);
        this.session = this.sendConnection.createSession(false, 1);
        this.receiveSession = this.receiveConnection.createSession(false, 1);
        log.info("Created sendSession: " + this.session);
        log.info("Created receiveSession: " + this.receiveSession);
        this.producer = this.session.createProducer(null);
        log.info("Created producer: " + this.producer);
        if (this.topic) {
            this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
            this.producerDestination = this.session.createTopic(this.getProducerSubject());
        } else {
            this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
            this.producerDestination = this.session.createQueue(this.getProducerSubject());
        }
        log.info("Created  consumer destination: " + this.consumerDestination + " of type: " + this.consumerDestination.getClass());
        log.info("Created  producer destination: " + this.producerDestination + " of type: " + this.producerDestination.getClass());
        Destination[] destinations = this.getDestinations();
        this.consumers = new MessageConsumer[destinations.length];
        this.messageLists = new List[destinations.length];
        for (int i = 0; i < destinations.length; ++i) {
            Destination dest = destinations[i];
            this.messageLists[i] = this.createConcurrentList();
            this.consumers[i] = this.receiveSession.createConsumer(dest);
            this.consumers[i].setMessageListener(this.createMessageListener(i, this.messageLists[i]));
        }
        log.info("Started connections");
    }

    protected MessageListener createMessageListener(int i, final List messageList) {
        return new MessageListener(){

            public void onMessage(Message message) {
                CompositePublishTest.this.consumeMessage(message, messageList);
            }
        };
    }

    protected String getSubject() {
        return this.getPrefix() + "FOO.BAR," + this.getPrefix() + "FOO.X.Y";
    }

    protected Destination[] getDestinations() {
        return new Destination[]{new ActiveMQTopic(this.getPrefix() + "FOO.BAR"), new ActiveMQTopic(this.getPrefix() + "FOO.*"), new ActiveMQTopic(this.getPrefix() + "FOO.X.Y")};
    }

    protected String getPrefix() {
        return super.getSubject() + ".";
    }

    protected void assertMessagesAreReceived() throws JMSException {
        int i;
        this.waitForMessagesToBeDelivered();
        int size = this.messageLists.length;
        for (i = 0; i < size; ++i) {
            log.info("Message list: " + i + " contains: " + this.messageLists[i].size() + " message(s)");
        }
        size = this.messageLists.length;
        for (i = 0; i < size; ++i) {
            this.assertMessagesReceivedAreValid(this.messageLists[i]);
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() {
        return new ActiveMQConnectionFactory("vm://localhost");
    }

    protected void tearDown() throws Exception {
        this.session.close();
        this.receiveSession.close();
        this.sendConnection.close();
        this.receiveConnection.close();
    }
}

