/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.jms.MessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.util.MessageIdList;

public class MultiBrokersMultiClientsTest
extends JmsMultipleBrokersTestSupport {
    public static final int BROKER_COUNT = 2;
    public static final int CONSUMER_COUNT = 3;
    public static final int PRODUCER_COUNT = 3;
    public static final int MESSAGE_COUNT = 10;
    protected Map consumerMap;

    public void testTopicAllConnected() throws Exception {
        int j;
        int i;
        this.bridgeAllBrokers();
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        for (i = 1; i <= 2; ++i) {
            for (j = 0; j < 3; ++j) {
                this.consumerMap.put("Consumer:" + i + ":" + j, this.createConsumer("Broker" + i, dest));
            }
        }
        Thread.sleep(2000L);
        for (i = 1; i <= 2; ++i) {
            for (j = 0; j < 3; ++j) {
                this.sendMessages("Broker" + i, dest, 10);
            }
        }
        for (i = 1; i <= 2; ++i) {
            for (j = 0; j < 3; ++j) {
                MessageIdList msgs = this.getConsumerMessages("Broker" + i, (MessageConsumer)this.consumerMap.get("Consumer:" + i + ":" + j));
                msgs.waitForMessagesToArrive(60);
                MultiBrokersMultiClientsTest.assertEquals((int)60, (int)msgs.getMessageCount());
            }
        }
    }

    public void testQueueAllConnected() throws Exception {
        int j;
        int i;
        this.bridgeAllBrokers();
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        for (i = 1; i <= 2; ++i) {
            for (j = 0; j < 3; ++j) {
                this.consumerMap.put("Consumer:" + i + ":" + j, this.createConsumer("Broker" + i, dest));
            }
        }
        Thread.sleep(2000L);
        for (i = 1; i <= 2; ++i) {
            for (j = 0; j < 3; ++j) {
                this.sendMessages("Broker" + i, dest, 10);
            }
        }
        Thread.sleep(2000L);
        int totalMsg = 0;
        for (int i2 = 1; i2 <= 2; ++i2) {
            for (int j2 = 0; j2 < 3; ++j2) {
                MessageIdList msgs = this.getConsumerMessages("Broker" + i2, (MessageConsumer)this.consumerMap.get("Consumer:" + i2 + ":" + j2));
                totalMsg += msgs.getMessageCount();
            }
        }
        MultiBrokersMultiClientsTest.assertEquals((int)60, (int)totalMsg);
    }

    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        for (int i = 1; i <= 2; ++i) {
            this.createBroker(new URI("broker:()/Broker" + i + "?persistent=false&useJmx=false"));
        }
        this.consumerMap = new HashMap();
    }
}

