/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;

public class NewConsumerCreatesDestinationTest
extends EmbeddedBrokerTestSupport {
    private Connection connection;
    private ActiveMQQueue wildcard;

    public void testNewConsumerCausesNewDestinationToBeAutoCreated() throws Exception {
        this.connection = this.createConnection();
        String wildcardText = "org.*" + this.getDestinationString().substring("org.apache".length());
        this.wildcard = new ActiveMQQueue(wildcardText);
        System.out.println("Using wildcard: " + this.wildcard);
        System.out.println("on destination: " + this.destination);
        this.assertDestinationCreated(this.destination, false);
        this.assertDestinationCreated(this.wildcard, false);
        Session session = this.connection.createSession(false, 1);
        session.createConsumer(this.destination);
        this.assertDestinationCreated(this.destination, true);
        this.assertDestinationCreated(this.wildcard, true);
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    protected void assertDestinationCreated(Destination destination, boolean expected) throws Exception {
        Set answer = this.broker.getBroker().getDestinations((ActiveMQDestination)destination);
        int size = expected ? 1 : 0;
        NewConsumerCreatesDestinationTest.assertEquals((String)("Size of found destinations: " + answer), (int)size, (int)answer.size());
    }
}

