/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.usecases.PublishOnTopicConsumedMessageTest;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class PublishOnQueueConsumedMessageUsingActivemqXMLTest
extends PublishOnTopicConsumedMessageTest {
    protected static final String JOURNAL_ROOT = "../data/";
    BrokerService broker;

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("tcp://localhost:61616");
    }

    protected void setUp() throws Exception {
        File journalFile = new File(JOURNAL_ROOT);
        PublishOnQueueConsumedMessageUsingActivemqXMLTest.recursiveDelete(journalFile);
        System.out.print("Creating broker... ");
        this.broker = this.createBroker("org/apache/activemq/usecases/activemq.xml");
        log.info("Success");
        super.setUp();
    }

    protected void tearDown() throws Exception {
        log.info("Closing Broker");
        if (this.broker != null) {
            this.broker.stop();
        }
        log.info("Broker closed...");
    }

    protected static void recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                PublishOnQueueConsumedMessageUsingActivemqXMLTest.recursiveDelete(files[i]);
            }
        }
        file.delete();
    }

    protected BrokerService createBroker(String resource) throws Exception {
        return this.createBroker((Resource)new ClassPathResource(resource));
    }

    protected BrokerService createBroker(Resource resource) throws Exception {
        BrokerFactoryBean factory = new BrokerFactoryBean(resource);
        factory.afterPropertiesSet();
        BrokerService broker = factory.getBroker();
        return broker;
    }
}

