/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.Serializable;
import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.test.TestSupport;
import org.apache.activemq.util.IdGenerator;

public class ReliableReconnectTest
extends TestSupport {
    private static final int RECEIVE_TIMEOUT = 10000;
    protected static final int MESSAGE_COUNT = 100;
    protected static final String DEFAULT_BROKER_URL = "vm://localhost";
    private IdGenerator idGen = new IdGenerator();
    protected int deliveryMode = 2;
    protected String consumerClientId;
    protected Destination destination;
    protected AtomicBoolean closeBroker = new AtomicBoolean(false);
    protected AtomicInteger messagesReceived = new AtomicInteger(0);
    protected BrokerService broker;
    protected int firstBatch = 10;

    public ReliableReconnectTest() {
    }

    public ReliableReconnectTest(String n) {
        super(n);
    }

    protected void setUp() throws Exception {
        this.consumerClientId = this.idGen.generateId();
        super.setUp();
        this.topic = true;
        this.destination = this.createDestination(((Object)((Object)this)).getClass().getName());
    }

    public ActiveMQConnectionFactory getConnectionFactory() throws Exception {
        String url = "failover://vm://localhost";
        return new ActiveMQConnectionFactory(url);
    }

    protected void startBroker() throws JMSException {
        try {
            this.broker = BrokerFactory.createBroker(new URI("broker://()/localhost"));
            this.broker.addConnector(DEFAULT_BROKER_URL);
            this.broker.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Connection createConsumerConnection() throws Exception {
        Connection consumerConnection = this.getConnectionFactory().createConnection();
        consumerConnection.setClientID(this.consumerClientId);
        consumerConnection.start();
        return consumerConnection;
    }

    protected MessageConsumer createConsumer(Connection con) throws Exception {
        Session s = con.createSession(false, 1);
        return s.createDurableSubscriber((Topic)this.destination, "TestFred");
    }

    protected void spawnConsumer() {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Message msg;
                    Connection consumerConnection = ReliableReconnectTest.this.createConsumerConnection();
                    MessageConsumer consumer = ReliableReconnectTest.this.createConsumer(consumerConnection);
                    for (int i = 0; i < ReliableReconnectTest.this.firstBatch; ++i) {
                        msg = consumer.receive(10000L);
                        if (msg == null) continue;
                        ReliableReconnectTest.this.messagesReceived.incrementAndGet();
                    }
                    AtomicBoolean i = ReliableReconnectTest.this.closeBroker;
                    synchronized (i) {
                        ReliableReconnectTest.this.closeBroker.set(true);
                        ReliableReconnectTest.this.closeBroker.notify();
                    }
                    Thread.sleep(2000L);
                    for (int i2 = ReliableReconnectTest.this.firstBatch; i2 < 100; ++i2) {
                        msg = consumer.receive(10000L);
                        if (msg == null) continue;
                        ReliableReconnectTest.this.messagesReceived.incrementAndGet();
                    }
                    consumerConnection.close();
                    AtomicInteger atomicInteger = ReliableReconnectTest.this.messagesReceived;
                    synchronized (atomicInteger) {
                        ReliableReconnectTest.this.messagesReceived.notify();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReconnect() throws Exception {
        this.startBroker();
        Connection consumerConnection = this.createConsumerConnection();
        this.createConsumer(consumerConnection);
        consumerConnection.close();
        Connection connection = this.createConnection();
        connection.setClientID(this.idGen.generateId());
        connection.start();
        Session producerSession = connection.createSession(false, 1);
        MessageProducer producer = producerSession.createProducer(this.destination);
        TextMessage msg = producerSession.createTextMessage();
        for (int i = 0; i < 100; ++i) {
            msg.setText("msg: " + i);
            producer.send(msg);
        }
        connection.close();
        this.spawnConsumer();
        Serializable i = this.closeBroker;
        synchronized (i) {
            if (!this.closeBroker.get()) {
                this.closeBroker.wait();
            }
        }
        this.broker.stop();
        this.startBroker();
        i = this.messagesReceived;
        synchronized (i) {
            if (this.messagesReceived.get() < 100) {
                this.messagesReceived.wait(60000L);
            }
        }
        int count = this.messagesReceived.get();
        ReliableReconnectTest.assertTrue((String)("Not enough messages received: " + count), (count > this.firstBatch ? 1 : 0) != 0);
    }
}

