/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.usecases.ThreeBrokerQueueNetworkTest;

public class ThreeBrokerQueueNetworkUsingTcpTest
extends ThreeBrokerQueueNetworkTest {
    protected List bridges;

    protected void bridgeBrokers(BrokerService localBroker, BrokerService remoteBroker) throws Exception {
        URI localURI;
        URI remoteURI;
        List remoteTransports = remoteBroker.getTransportConnectors();
        List localTransports = localBroker.getTransportConnectors();
        if (!remoteTransports.isEmpty() && !localTransports.isEmpty()) {
            remoteURI = ((TransportConnector)remoteTransports.get(0)).getConnectUri();
            localURI = ((TransportConnector)localTransports.get(0)).getConnectUri();
            if (!remoteURI.toString().startsWith("tcp:") || !localURI.toString().startsWith("tcp:")) {
                throw new Exception("Remote broker or local broker is not using tcp connectors");
            }
        } else {
            throw new Exception("Remote broker or local broker has no registered connectors.");
        }
        DemandForwardingBridge bridge = new DemandForwardingBridge(TransportFactory.connect(localURI), TransportFactory.connect(remoteURI));
        bridge.setLocalBrokerName(localBroker.getBrokerName());
        this.bridges.add(bridge);
        bridge.start();
        MAX_SETUP_TIME = 2000;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.bridges = new ArrayList();
    }
}

