/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import javax.jms.MessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.util.MessageIdList;

public class ThreeBrokerTopicNetworkTest
extends JmsMultipleBrokersTestSupport {
    protected static final int MESSAGE_COUNT = 100;

    public void test_AB_BC_BrokerNetwork() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.bridgeBrokers("BrokerB", "BrokerC");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", dest);
        MessageConsumer clientC = this.createConsumer("BrokerC", dest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", dest, 100);
        this.sendMessages("BrokerB", dest, 100);
        this.sendMessages("BrokerC", dest, 100);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        msgsA.waitForMessagesToArrive(100);
        msgsB.waitForMessagesToArrive(200);
        msgsC.waitForMessagesToArrive(200);
        ThreeBrokerTopicNetworkTest.assertEquals((int)100, (int)msgsA.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)200, (int)msgsB.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)200, (int)msgsC.getMessageCount());
    }

    public void test_BA_BC_BrokerNetwork() throws Exception {
        this.bridgeBrokers("BrokerB", "BrokerA");
        this.bridgeBrokers("BrokerB", "BrokerC");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", dest);
        MessageConsumer clientC = this.createConsumer("BrokerC", dest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", dest, 100);
        this.sendMessages("BrokerB", dest, 100);
        this.sendMessages("BrokerC", dest, 100);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        msgsA.waitForMessagesToArrive(200);
        msgsB.waitForMessagesToArrive(100);
        msgsC.waitForMessagesToArrive(200);
        ThreeBrokerTopicNetworkTest.assertEquals((int)200, (int)msgsA.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)100, (int)msgsB.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)200, (int)msgsC.getMessageCount());
    }

    public void test_AB_CB_BrokerNetwork() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.bridgeBrokers("BrokerC", "BrokerB");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", dest);
        MessageConsumer clientC = this.createConsumer("BrokerC", dest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", dest, 100);
        this.sendMessages("BrokerB", dest, 100);
        this.sendMessages("BrokerC", dest, 100);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        msgsA.waitForMessagesToArrive(100);
        msgsB.waitForMessagesToArrive(300);
        msgsC.waitForMessagesToArrive(100);
        ThreeBrokerTopicNetworkTest.assertEquals((int)100, (int)msgsA.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsB.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)100, (int)msgsC.getMessageCount());
    }

    public void testAllConnectedBrokerNetwork() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.bridgeBrokers("BrokerB", "BrokerA");
        this.bridgeBrokers("BrokerB", "BrokerC");
        this.bridgeBrokers("BrokerC", "BrokerB");
        this.bridgeBrokers("BrokerA", "BrokerC");
        this.bridgeBrokers("BrokerC", "BrokerA");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", dest);
        MessageConsumer clientC = this.createConsumer("BrokerC", dest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", dest, 100);
        this.sendMessages("BrokerB", dest, 100);
        this.sendMessages("BrokerC", dest, 100);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        msgsA.waitForMessagesToArrive(300);
        msgsB.waitForMessagesToArrive(300);
        msgsC.waitForMessagesToArrive(300);
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsA.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsB.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsC.getMessageCount());
    }

    public void testAllConnectedUsingMulticast() throws Exception {
        this.bridgeAllBrokers();
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", dest);
        MessageConsumer clientC = this.createConsumer("BrokerC", dest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", dest, 100);
        this.sendMessages("BrokerB", dest, 100);
        this.sendMessages("BrokerC", dest, 100);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        msgsA.waitForMessagesToArrive(300);
        msgsB.waitForMessagesToArrive(300);
        msgsC.waitForMessagesToArrive(300);
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsA.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsB.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsC.getMessageCount());
    }

    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.createBroker(new URI("broker:(tcp://localhost:61616)/BrokerA?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:(tcp://localhost:61617)/BrokerB?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:(tcp://localhost:61618)/BrokerC?persistent=false&useJmx=false"));
    }
}

