/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.jms.MessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Command;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.util.MessageIdList;

public class TwoBrokerMessageNotSentToRemoteWhenNoConsumerTest
extends JmsMultipleBrokersTestSupport {
    protected static final int MESSAGE_COUNT = 10;
    protected List bridges;
    protected AtomicInteger msgDispatchCount;

    public void testRemoteBrokerHasConsumer() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", dest);
        this.sendMessages("BrokerA", dest, 10);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        msgsA.waitForMessagesToArrive(10);
        msgsB.waitForMessagesToArrive(10);
        TwoBrokerMessageNotSentToRemoteWhenNoConsumerTest.assertEquals((int)10, (int)msgsA.getMessageCount());
        TwoBrokerMessageNotSentToRemoteWhenNoConsumerTest.assertEquals((int)10, (int)msgsB.getMessageCount());
        TwoBrokerMessageNotSentToRemoteWhenNoConsumerTest.assertEquals((int)10, (int)this.msgDispatchCount.get());
    }

    public void testRemoteBrokerHasNoConsumer() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", dest);
        this.sendMessages("BrokerA", dest, 10);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        msgsA.waitForMessagesToArrive(10);
        TwoBrokerMessageNotSentToRemoteWhenNoConsumerTest.assertEquals((int)10, (int)msgsA.getMessageCount());
        TwoBrokerMessageNotSentToRemoteWhenNoConsumerTest.assertEquals((int)0, (int)this.msgDispatchCount.get());
    }

    protected void bridgeBrokers(BrokerService localBroker, BrokerService remoteBroker) throws Exception {
        URI localURI;
        URI remoteURI;
        List remoteTransports = remoteBroker.getTransportConnectors();
        List localTransports = localBroker.getTransportConnectors();
        if (!remoteTransports.isEmpty() && !localTransports.isEmpty()) {
            remoteURI = ((TransportConnector)remoteTransports.get(0)).getConnectUri();
            localURI = ((TransportConnector)localTransports.get(0)).getConnectUri();
            if (!remoteURI.toString().startsWith("tcp:") || !localURI.toString().startsWith("tcp:")) {
                throw new Exception("Remote broker or local broker is not using tcp connectors");
            }
        } else {
            throw new Exception("Remote broker or local broker has no registered connectors.");
        }
        DemandForwardingBridge bridge = new DemandForwardingBridge(TransportFactory.connect(localURI), TransportFactory.connect(remoteURI)){

            protected void serviceLocalCommand(Command command) {
                if (command.isMessageDispatch()) {
                    TwoBrokerMessageNotSentToRemoteWhenNoConsumerTest.this.msgDispatchCount.incrementAndGet();
                }
                super.serviceLocalCommand(command);
            }
        };
        bridge.setLocalBrokerName(localBroker.getBrokerName());
        this.bridges.add(bridge);
        bridge.start();
        MAX_SETUP_TIME = 2000;
    }

    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.createBroker(new URI("broker:(tcp://localhost:61616)/BrokerA?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:(tcp://localhost:61617)/BrokerB?persistent=false&useJmx=false"));
        this.bridges = new ArrayList();
        this.msgDispatchCount = new AtomicInteger(0);
    }
}

