/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.common.properties;

import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.underlying.common.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.underlying.common.properties.TypedPropertyKey;
import org.apache.shardingsphere.underlying.common.properties.TypedPropertyValue;
import org.apache.shardingsphere.underlying.common.properties.TypedPropertyValueException;

public abstract class TypedProperties<E extends Enum> {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Properties props;
    private final Map<E, TypedPropertyValue> cache;

    public TypedProperties(Class<E> keyClass, Properties props) {
        this.props = props;
        this.cache = this.preload(keyClass);
    }

    private Map<E, TypedPropertyValue> preload(Class<E> keyClass) {
        Enum[] enumConstants = (Enum[])keyClass.getEnumConstants();
        HashMap<Enum, TypedPropertyValue> result = new HashMap<Enum, TypedPropertyValue>(enumConstants.length, 1.0f);
        LinkedList<String> errorMessages = new LinkedList<String>();
        for (Enum each : enumConstants) {
            TypedPropertyValue value = null;
            try {
                value = new TypedPropertyValue((TypedPropertyKey)((Object)each), this.props.getOrDefault((Object)((TypedPropertyKey)((Object)each)).getKey(), ((TypedPropertyKey)((Object)each)).getDefaultValue()).toString());
            }
            catch (TypedPropertyValueException ex) {
                errorMessages.add(ex.getMessage());
            }
            result.put(each, value);
        }
        if (!errorMessages.isEmpty()) {
            throw new ShardingSphereConfigurationException(Joiner.on((String)LINE_SEPARATOR).join(errorMessages), new Object[0]);
        }
        return result;
    }

    public <T> T getValue(E key) {
        return (T)this.cache.get(key).getValue();
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

