/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.projection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.DerivedProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class ProjectionsContext {
    private final int startIndex;
    private final int stopIndex;
    private final boolean distinctRow;
    private final Collection<Projection> projections;
    private final Collection<AggregationDistinctProjection> aggregationDistinctProjections;
    private final List<Projection> expandProjections;

    public ProjectionsContext(int startIndex, int stopIndex, boolean distinctRow, Collection<Projection> projections) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.distinctRow = distinctRow;
        this.projections = projections;
        this.aggregationDistinctProjections = this.createAggregationDistinctProjections();
        this.expandProjections = this.expandProjections();
    }

    private Collection<AggregationDistinctProjection> createAggregationDistinctProjections() {
        LinkedList<AggregationDistinctProjection> result = new LinkedList<AggregationDistinctProjection>();
        for (Projection each : this.projections) {
            if (!(each instanceof AggregationDistinctProjection)) continue;
            result.add((AggregationDistinctProjection)each);
        }
        return result;
    }

    private List<Projection> expandProjections() {
        ArrayList<Projection> result = new ArrayList<Projection>();
        for (Projection each : this.projections) {
            if (each instanceof ShorthandProjection) {
                result.addAll(((ShorthandProjection)each).getActualColumns().values());
                continue;
            }
            if (each instanceof DerivedProjection) continue;
            result.add(each);
        }
        return result;
    }

    public boolean isUnqualifiedShorthandProjection() {
        if (1 != this.projections.size()) {
            return false;
        }
        Projection projection = this.projections.iterator().next();
        return projection instanceof ShorthandProjection && !((ShorthandProjection)projection).getOwner().isPresent();
    }

    public Optional<String> findAlias(String projectionName) {
        for (Projection each : this.projections) {
            if (each instanceof ShorthandProjection && ((ShorthandProjection)each).getActualColumns().containsKey(projectionName.toLowerCase())) {
                return ((ShorthandProjection)each).getActualColumns().get(projectionName.toLowerCase()).getAlias();
            }
            if (!projectionName.equalsIgnoreCase(SQLUtil.getExactlyValue((String)each.getExpression()))) continue;
            return each.getAlias();
        }
        return Optional.empty();
    }

    public Optional<Integer> findProjectionIndex(String projectionName) {
        int result = 1;
        for (Projection each : this.projections) {
            if (projectionName.equalsIgnoreCase(SQLUtil.getExactlyValue((String)each.getExpression()))) {
                return Optional.of(result);
            }
            ++result;
        }
        return Optional.empty();
    }

    public List<AggregationProjection> getAggregationProjections() {
        LinkedList<AggregationProjection> result = new LinkedList<AggregationProjection>();
        for (Projection each : this.projections) {
            if (!(each instanceof AggregationProjection)) continue;
            AggregationProjection aggregationProjection = (AggregationProjection)each;
            result.add(aggregationProjection);
            result.addAll(aggregationProjection.getDerivedAggregationProjections());
        }
        return result;
    }

    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }

    @Generated
    public boolean isDistinctRow() {
        return this.distinctRow;
    }

    @Generated
    public Collection<Projection> getProjections() {
        return this.projections;
    }

    @Generated
    public Collection<AggregationDistinctProjection> getAggregationDistinctProjections() {
        return this.aggregationDistinctProjections;
    }

    @Generated
    public List<Projection> getExpandProjections() {
        return this.expandProjections;
    }

    @Generated
    public String toString() {
        return "ProjectionsContext(startIndex=" + this.getStartIndex() + ", stopIndex=" + this.getStopIndex() + ", distinctRow=" + this.isDistinctRow() + ", projections=" + this.getProjections() + ", aggregationDistinctProjections=" + this.getAggregationDistinctProjections() + ", expandProjections=" + this.getExpandProjections() + ")";
    }
}

