/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.rewrite.engine;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.underlying.common.rule.DataNode;
import org.apache.shardingsphere.underlying.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.underlying.rewrite.engine.SQLRewriteResult;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.sql.impl.RouteSQLBuilder;
import org.apache.shardingsphere.underlying.route.context.RouteResult;
import org.apache.shardingsphere.underlying.route.context.RouteUnit;

public final class SQLRouteRewriteEngine {
    public Map<RouteUnit, SQLRewriteResult> rewrite(SQLRewriteContext sqlRewriteContext, RouteResult routeResult) {
        LinkedHashMap<RouteUnit, SQLRewriteResult> result = new LinkedHashMap<RouteUnit, SQLRewriteResult>(routeResult.getRouteUnits().size(), 1.0f);
        for (RouteUnit each : routeResult.getRouteUnits()) {
            result.put(each, new SQLRewriteResult(new RouteSQLBuilder(sqlRewriteContext, each).toSQL(), this.getParameters(sqlRewriteContext.getParameterBuilder(), routeResult, each)));
        }
        return result;
    }

    private List<Object> getParameters(ParameterBuilder parameterBuilder, RouteResult routeResult, RouteUnit routeUnit) {
        if (parameterBuilder instanceof StandardParameterBuilder || routeResult.getOriginalDataNodes().isEmpty() || parameterBuilder.getParameters().isEmpty()) {
            return parameterBuilder.getParameters();
        }
        LinkedList<Object> result = new LinkedList<Object>();
        int count = 0;
        for (Collection each : routeResult.getOriginalDataNodes()) {
            if (this.isInSameDataNode(each, routeUnit)) {
                result.addAll(((GroupedParameterBuilder)parameterBuilder).getParameters(count));
            }
            ++count;
        }
        return result;
    }

    private boolean isInSameDataNode(Collection<DataNode> dataNodes, RouteUnit routeUnit) {
        if (dataNodes.isEmpty()) {
            return true;
        }
        for (DataNode each : dataNodes) {
            if (!routeUnit.findTableMapper(each.getDataSourceName(), each.getTableName()).isPresent()) continue;
            return true;
        }
        return false;
    }
}

