/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.preprocess;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.shardingsphere.infra.distsql.preprocess.RuleDefinitionAlterPreprocessor;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterShardingTableRuleStatement;

public final class AlterShardingTableRuleStatementPreprocessor
implements RuleDefinitionAlterPreprocessor<AlterShardingTableRuleStatement, ShardingRuleConfiguration> {
    public String getType() {
        return AlterShardingTableRuleStatement.class.getCanonicalName();
    }

    public ShardingRuleConfiguration preprocess(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        result.setShardingAlgorithms(currentRuleConfig.getShardingAlgorithms());
        result.setAutoTables(currentRuleConfig.getAutoTables());
        result.setDefaultShardingColumn(currentRuleConfig.getDefaultShardingColumn());
        result.setDefaultTableShardingStrategy(currentRuleConfig.getDefaultTableShardingStrategy());
        result.setBindingTableGroups(currentRuleConfig.getBindingTableGroups());
        result.setDefaultDatabaseShardingStrategy(currentRuleConfig.getDefaultDatabaseShardingStrategy());
        result.setTables(currentRuleConfig.getTables());
        result.setBroadcastTables(currentRuleConfig.getBroadcastTables());
        result.setDefaultKeyGenerateStrategy(currentRuleConfig.getDefaultKeyGenerateStrategy());
        result.setKeyGenerators(currentRuleConfig.getKeyGenerators());
        this.dropRuleConfiguration(result, toBeAlteredRuleConfig);
        this.addRuleConfiguration(result, toBeAlteredRuleConfig);
        return result;
    }

    private void dropRuleConfiguration(ShardingRuleConfiguration preAlteredRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        for (ShardingAutoTableRuleConfiguration each : toBeAlteredRuleConfig.getAutoTables()) {
            Optional<ShardingAutoTableRuleConfiguration> shardingAutoTableRuleConfig = preAlteredRuleConfig.getAutoTables().stream().filter(tableRule -> each.getLogicTable().equals(tableRule.getLogicTable())).findAny();
            Preconditions.checkState((boolean)shardingAutoTableRuleConfig.isPresent());
            preAlteredRuleConfig.getAutoTables().remove(shardingAutoTableRuleConfig.get());
            preAlteredRuleConfig.getShardingAlgorithms().remove(shardingAutoTableRuleConfig.get().getShardingStrategy().getShardingAlgorithmName());
            if (null == shardingAutoTableRuleConfig.get().getKeyGenerateStrategy()) continue;
            preAlteredRuleConfig.getKeyGenerators().remove(shardingAutoTableRuleConfig.get().getKeyGenerateStrategy().getKeyGeneratorName());
        }
    }

    private void addRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        currentRuleConfig.getAutoTables().addAll(toBeAlteredRuleConfig.getAutoTables());
        currentRuleConfig.getShardingAlgorithms().putAll(toBeAlteredRuleConfig.getShardingAlgorithms());
        currentRuleConfig.getKeyGenerators().putAll(toBeAlteredRuleConfig.getKeyGenerators());
    }
}

