/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.exception.rule.AlgorithmInUsedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredAlgorithmMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleDefinitionViolationException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingAlgorithmStatement;

public final class DropShardingAlgorithmStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingAlgorithmStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, DropShardingAlgorithmStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws RuleDefinitionViolationException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkCurrentRuleConfiguration(schemaName, currentRuleConfig);
        this.checkToBeDroppedShardingAlgorithms(schemaName, sqlStatement, currentRuleConfig);
        this.checkShardingAlgorithmsInUsed(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String schemaName, ShardingRuleConfiguration currentRuleConfig) throws RequiredAlgorithmMissedException {
        if (null == currentRuleConfig) {
            throw new RequiredAlgorithmMissedException(schemaName);
        }
    }

    private void checkToBeDroppedShardingAlgorithms(String schemaName, DropShardingAlgorithmStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws RequiredAlgorithmMissedException {
        Collection<String> currentShardingAlgorithms = this.getCurrentShardingAlgorithms(currentRuleConfig);
        Collection notExistedAlgorithms = sqlStatement.getAlgorithmNames().stream().filter(each -> !currentShardingAlgorithms.contains(each)).collect(Collectors.toList());
        if (!notExistedAlgorithms.isEmpty()) {
            throw new RequiredAlgorithmMissedException(schemaName, notExistedAlgorithms);
        }
    }

    private void checkShardingAlgorithmsInUsed(String schemaName, DropShardingAlgorithmStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws AlgorithmInUsedException {
        Collection<String> allInUsed = this.getAllOfAlgorithmsInUsed(currentRuleConfig);
        Collection usedAlgorithms = sqlStatement.getAlgorithmNames().stream().filter(allInUsed::contains).collect(Collectors.toList());
        if (!usedAlgorithms.isEmpty()) {
            throw new AlgorithmInUsedException(schemaName, usedAlgorithms);
        }
    }

    private Collection<String> getAllOfAlgorithmsInUsed(ShardingRuleConfiguration shardingRuleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getTables().forEach(each -> {
            if (Objects.nonNull(each.getDatabaseShardingStrategy())) {
                result.add(each.getDatabaseShardingStrategy().getShardingAlgorithmName());
            }
            if (Objects.nonNull(each.getTableShardingStrategy())) {
                result.add(each.getTableShardingStrategy().getShardingAlgorithmName());
            }
        });
        shardingRuleConfig.getAutoTables().stream().filter(each -> Objects.nonNull(each.getShardingStrategy())).forEach(each -> result.add(each.getShardingStrategy().getShardingAlgorithmName()));
        return result;
    }

    private Collection<String> getCurrentShardingAlgorithms(ShardingRuleConfiguration shardingRuleConfig) {
        return shardingRuleConfig.getShardingAlgorithms().keySet();
    }

    public boolean updateCurrentRuleConfiguration(DropShardingAlgorithmStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        for (String each : sqlStatement.getAlgorithmNames()) {
            this.dropShardingAlgorithm(currentRuleConfig, each);
        }
        return false;
    }

    private void dropShardingAlgorithm(ShardingRuleConfiguration currentRuleConfig, String algorithmName) {
        this.getCurrentShardingAlgorithms(currentRuleConfig).removeIf(algorithmName::equalsIgnoreCase);
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return DropShardingAlgorithmStatement.class.getCanonicalName();
    }
}

