/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingBindingTableRulesStatement;

public final class DropShardingBindingTableRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingBindingTableRulesStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, DropShardingBindingTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkCurrentRuleConfiguration(schemaName, currentRuleConfig);
        this.checkBindingTableRuleExist(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String schemaName, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((null != currentRuleConfig && !currentRuleConfig.getBindingTableGroups().isEmpty() ? 1 : 0) != 0, (DistSQLException)new RequiredRuleMissedException("Binding", schemaName));
    }

    private void checkBindingTableRuleExist(String schemaName, DropShardingBindingTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection bindingTableGroups = currentRuleConfig.getBindingTableGroups();
        LinkedList notExistBindingGroup = sqlStatement.getBindingGroups().stream().filter(each -> !bindingTableGroups.contains(each)).collect(Collectors.toCollection(LinkedList::new));
        DistSQLException.predictionThrow((boolean)notExistBindingGroup.isEmpty(), (DistSQLException)new RequiredRuleMissedException("Binding", schemaName, (Collection)notExistBindingGroup));
    }

    public boolean updateCurrentRuleConfiguration(DropShardingBindingTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (sqlStatement.getRules().isEmpty()) {
            currentRuleConfig.getBindingTableGroups().clear();
        } else {
            currentRuleConfig.getBindingTableGroups().removeIf(sqlStatement.getBindingGroups()::contains);
        }
        return false;
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return DropShardingBindingTableRulesStatement.class.getCanonicalName();
    }
}

