/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.segment.table;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;

public final class TablesContext {
    private final Collection<SimpleTableSegment> tables;

    public TablesContext(SimpleTableSegment tableSegment) {
        this(null == tableSegment ? Collections.emptyList() : Collections.singletonList(tableSegment));
    }

    public Collection<String> getTableNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.tables.size(), 1.0f);
        for (SimpleTableSegment each : this.tables) {
            result.add(each.getTableName().getIdentifier().getValue());
        }
        return result;
    }

    public Optional<String> findTableName(ColumnSegment column, SchemaMetaData schemaMetaData) {
        if (1 == this.tables.size()) {
            return Optional.of(this.tables.iterator().next().getTableName().getIdentifier().getValue());
        }
        if (column.getOwner().isPresent()) {
            return Optional.of(this.findTableNameFromSQL(((OwnerSegment)column.getOwner().get()).getIdentifier().getValue()));
        }
        return this.findTableNameFromMetaData(column.getIdentifier().getValue(), schemaMetaData);
    }

    public Optional<String> findTableName(ColumnProjection column, SchemaMetaData schemaMetaData) {
        if (1 == this.tables.size()) {
            return Optional.of(this.tables.iterator().next().getTableName().getIdentifier().getValue());
        }
        if (null != column.getOwner()) {
            return Optional.of(this.findTableNameFromSQL(column.getOwner()));
        }
        return this.findTableNameFromMetaData(column.getName(), schemaMetaData);
    }

    private String findTableNameFromSQL(String tableNameOrAlias) {
        for (SimpleTableSegment each : this.tables) {
            if (!tableNameOrAlias.equalsIgnoreCase(each.getTableName().getIdentifier().getValue()) && !tableNameOrAlias.equals(each.getAlias().orElse(null))) continue;
            return each.getTableName().getIdentifier().getValue();
        }
        throw new IllegalStateException("Can not find owner from table.");
    }

    private Optional<String> findTableNameFromMetaData(String columnName, SchemaMetaData schemaMetaData) {
        for (SimpleTableSegment each : this.tables) {
            if (!schemaMetaData.containsColumn(each.getTableName().getIdentifier().getValue(), columnName)) continue;
            return Optional.of(each.getTableName().getIdentifier().getValue());
        }
        return Optional.empty();
    }

    @Generated
    public TablesContext(Collection<SimpleTableSegment> tables) {
        this.tables = tables;
    }
}

