/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.yixintong.service;

import cn.hutool.core.util.StrUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.api.utils.SmsRespUtils;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.dromara.sms4j.yixintong.config.YiXintongConfig;
import org.dromara.sms4j.yixintong.utils.YiXintongUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YiXintongSmsImpl
extends AbstractSmsBlend<YiXintongConfig> {
    private static final Logger log = LoggerFactory.getLogger(YiXintongSmsImpl.class);
    private int retry = 0;

    public YiXintongSmsImpl(YiXintongConfig config, Executor pool, DelayedTime delayedTime) {
        super(config, pool, delayedTime);
    }

    public YiXintongSmsImpl(YiXintongConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "yixintong";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        return this.getSmsResponse(phone, message, ((YiXintongConfig)this.getConfig()).getTemplateId());
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        return this.getSmsResponse(SmsUtils.joinComma(phones), message, ((YiXintongConfig)this.getConfig()).getTemplateId());
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        throw new SmsBlendException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        throw new SmsBlendException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        throw new SmsBlendException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    private SmsResponse getSmsResponse(String phone, String message, String templateId) {
        SmsResponse smsResponse;
        YiXintongConfig config = (YiXintongConfig)this.getConfig();
        if (StrUtil.isBlank((CharSequence)phone)) {
            log.error("phone is required.");
            throw new SmsBlendException("phone is required.");
        }
        if (StrUtil.isBlank((CharSequence)message)) {
            log.error("message is required.");
            throw new SmsBlendException("message is required.");
        }
        String serialNumber = SmsUtils.getRandomInt((int)20);
        HashMap<String, Object> forms = new HashMap<String, Object>();
        forms.put("SpCode", config.getSpCode());
        forms.put("LoginName", config.getAccessKeyId());
        forms.put("Password", config.getAccessKeySecret());
        forms.put("MessageContent", message);
        forms.put("UserNumber", phone);
        forms.put("templateId", templateId);
        forms.put("SerialNumber", serialNumber);
        forms.put("ScheduleTime", "");
        forms.put("f", config.getF());
        forms.put("signCode", config.getSignCode());
        try {
            smsResponse = this.getResponse(YiXintongUtils.postForm(config.getRequestUrl(), forms));
        }
        catch (SmsBlendException e) {
            smsResponse = this.errorResp(e.message);
        }
        if (smsResponse.isSuccess() || this.retry == config.getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(phone, message, templateId);
    }

    private SmsResponse requestRetry(String phone, String message, String templateId) {
        this.http.safeSleep(((YiXintongConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("The SMS has been resent for the {}th time.", (Object)this.retry);
        return this.getSmsResponse(phone, message, templateId);
    }

    private SmsResponse getResponse(String body) {
        return SmsRespUtils.resp((Object)body, (boolean)StrUtil.contains((CharSequence)body, (CharSequence)"result=0&"), (String)this.getConfigId());
    }
}

