/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.entitylink.api.history.HistoricEntityLink;
import org.flowable.entitylink.api.history.HistoricEntityLinkService;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class EntityLinkDeletedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    public EntityLinkDeletedHistoryJsonTransformer(CmmnEngineConfiguration cmmnEngineConfiguration) {
        super(cmmnEngineConfiguration);
    }

    public List<String> getTypes() {
        return Collections.singletonList("cmmn-entity-link-deleted");
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return this.getHistoricEntityLink(historicalData, commandContext) != null;
    }

    protected HistoricEntityLink getHistoricEntityLink(ObjectNode historicalData, CommandContext commandContext) {
        return this.cmmnEngineConfiguration.getEntityLinkServiceConfiguration().getHistoricEntityLinkService().getHistoricEntityLink(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id"));
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricEntityLinkService historicEntityLinkService = this.cmmnEngineConfiguration.getEntityLinkServiceConfiguration().getHistoricEntityLinkService();
        HistoricEntityLink historicEntityLink = this.getHistoricEntityLink(historicalData, commandContext);
        if (historicEntityLink != null) {
            historicEntityLinkService.deleteHistoricEntityLink(historicEntityLink);
        }
    }
}

