/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import org.glassfish.tyrus.core.MaskingKeyGenerator;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;

public enum Version {
    DRAFT17("13"){

        @Override
        public ProtocolHandler createHandler(boolean mask, MaskingKeyGenerator maskingKeyGenerator) {
            return new ProtocolHandler(mask, maskingKeyGenerator);
        }

        @Override
        public boolean validate(UpgradeRequest request) {
            return this.wireProtocolVersion.equals(request.getHeader("Sec-WebSocket-Version"));
        }
    };

    final String wireProtocolVersion;

    public abstract ProtocolHandler createHandler(boolean var1, MaskingKeyGenerator var2);

    public abstract boolean validate(UpgradeRequest var1);

    private Version(String wireProtocolVersion) {
        this.wireProtocolVersion = wireProtocolVersion;
    }

    public String toString() {
        return this.name();
    }

    public static String getSupportedWireProtocolVersions() {
        StringBuilder sb = new StringBuilder();
        for (Version v : Version.values()) {
            if (v.wireProtocolVersion.length() <= 0) continue;
            sb.append(v.wireProtocolVersion).append(", ");
        }
        return sb.substring(0, sb.length() - 2);
    }
}

