/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.boot.starter.lock.config;

import org.jeecg.boot.starter.lock.core.RedissonManager;
import org.jeecg.boot.starter.lock.prop.RedissonProperties;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RedissonProperties.class})
@EnableConfigurationProperties(value={RedissonProperties.class})
public class RedissonConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedissonConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={RedissonClient.class})
    public RedissonClient redissonClient(RedissonProperties redissonProperties) {
        RedissonManager redissonManager = new RedissonManager(redissonProperties);
        log.info("RedissonManager\u521d\u59cb\u5316\u5b8c\u6210,\u5f53\u524d\u8fde\u63a5\u65b9\u5f0f:" + redissonProperties.getType() + ",\u8fde\u63a5\u5730\u5740:" + redissonProperties.getAddress());
        return redissonManager.getRedisson();
    }
}

