/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.security;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.alibaba.nacos.plugin.auth.spi.client.ClientAuthPluginManager;
import com.alibaba.nacos.plugin.auth.spi.client.ClientAuthService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SecurityProxy
implements Closeable {
    private ClientAuthPluginManager clientAuthPluginManager = new ClientAuthPluginManager();

    public SecurityProxy(List<String> serverList, NacosRestTemplate nacosRestTemplate) {
        this.clientAuthPluginManager.init(serverList, nacosRestTemplate);
    }

    public void login(Properties properties) {
        if (this.clientAuthPluginManager.getAuthServiceSpiImplSet().isEmpty()) {
            return;
        }
        for (ClientAuthService clientAuthService : this.clientAuthPluginManager.getAuthServiceSpiImplSet()) {
            clientAuthService.login(properties);
        }
    }

    public Map<String, String> getIdentityContext(RequestResource resource) {
        HashMap<String, String> header = new HashMap<String, String>(1);
        for (ClientAuthService clientAuthService : this.clientAuthPluginManager.getAuthServiceSpiImplSet()) {
            LoginIdentityContext loginIdentityContext = clientAuthService.getLoginIdentityContext(resource);
            for (String key : loginIdentityContext.getAllKey()) {
                header.put(key, loginIdentityContext.getParameter(key));
            }
        }
        return header;
    }

    public void shutdown() throws NacosException {
        this.clientAuthPluginManager.shutdown();
    }
}

