/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.core.CatalogService;
import com.alibaba.nacos.naming.core.CatalogServiceV2Impl;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/ns/catalog"})
public class CatalogController {
    @Autowired
    private CatalogServiceV2Impl catalogServiceV2;

    @Secured(action=ActionTypes.READ)
    @GetMapping(value={"/service"})
    public Object serviceDetail(@RequestParam(defaultValue="public") String namespaceId, String serviceName) throws NacosException {
        String serviceNameWithoutGroup = NamingUtils.getServiceName((String)serviceName);
        String groupName = NamingUtils.getGroupName((String)serviceName);
        return this.judgeCatalogService().getServiceDetail(namespaceId, groupName, serviceNameWithoutGroup);
    }

    @Secured(action=ActionTypes.READ)
    @RequestMapping(value={"/instances"})
    public ObjectNode instanceList(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam String clusterName, @RequestParam(name="pageNo") int page, @RequestParam int pageSize) throws NacosException {
        String serviceNameWithoutGroup = NamingUtils.getServiceName((String)serviceName);
        String groupName = NamingUtils.getGroupName((String)serviceName);
        List<? extends Instance> instances = this.judgeCatalogService().listInstances(namespaceId, groupName, serviceNameWithoutGroup, clusterName);
        int start = (page - 1) * pageSize;
        int end = page * pageSize;
        if (start < 0) {
            start = 0;
        }
        if (start > instances.size()) {
            start = instances.size();
        }
        if (end > instances.size()) {
            end = instances.size();
        }
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.replace("list", JacksonUtils.transferToJsonNode(instances.subList(start, end)));
        result.put("count", instances.size());
        return result;
    }

    @Secured(action=ActionTypes.READ)
    @GetMapping(value={"/services"})
    public Object listDetail(@RequestParam(required=false) boolean withInstances, @RequestParam(defaultValue="public") String namespaceId, @RequestParam(required=false) int pageNo, @RequestParam(required=false) int pageSize, @RequestParam(name="serviceNameParam", defaultValue="") String serviceName, @RequestParam(name="groupNameParam", defaultValue="") String groupName, @RequestParam(name="instance", defaultValue="") String containedInstance, @RequestParam(required=false) boolean hasIpCount) throws NacosException {
        if (withInstances) {
            return this.judgeCatalogService().pageListServiceDetail(namespaceId, groupName, serviceName, pageNo, pageSize);
        }
        return this.judgeCatalogService().pageListService(namespaceId, groupName, serviceName, pageNo, pageSize, containedInstance, hasIpCount);
    }

    private CatalogService judgeCatalogService() {
        return this.catalogServiceV2;
    }
}

