/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.sys.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.env.Environment;

public class PropertiesUtil {
    public static Properties getPropertiesWithPrefix(Environment environment, String prefix) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return PropertiesUtil.handleSpringBinder(environment, prefix, Properties.class);
    }

    public static Map<String, Object> getPropertiesWithPrefixForMap(Environment environment, String prefix) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return PropertiesUtil.handleSpringBinder(environment, prefix, Map.class);
    }

    public static <T> T handleSpringBinder(Environment environment, String prefix, Class<T> targetClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> binderClass = Class.forName("org.springframework.boot.context.properties.bind.Binder");
        Method getMethod = binderClass.getDeclaredMethod("get", Environment.class);
        Method bindMethod = binderClass.getDeclaredMethod("bind", String.class, Class.class);
        Object binderObject = getMethod.invoke(null, environment);
        String prefixParam = prefix.endsWith(".") ? prefix.substring(0, prefix.length() - 1) : prefix;
        Object bindResultObject = bindMethod.invoke(binderObject, prefixParam, targetClass);
        Method resultGetMethod = bindResultObject.getClass().getDeclaredMethod("get", new Class[0]);
        return (T)resultGetMethod.invoke(bindResultObject, new Object[0]);
    }
}

