/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.Optional;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.ClassOrdererContext;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.TestClassOrder;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.jupiter.engine.descriptor.TestClassAware;
import org.junit.jupiter.engine.discovery.AbstractOrderingVisitor;
import org.junit.jupiter.engine.discovery.DefaultClassDescriptor;
import org.junit.jupiter.engine.discovery.DefaultClassOrdererContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.LruCache;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

class ClassOrderingVisitor
extends AbstractOrderingVisitor {
    private final LruCache<ClassBasedTestDescriptor, AbstractOrderingVisitor.DescriptorWrapperOrderer<TestDescriptor, ClassOrderer, DefaultClassDescriptor>> ordererCache = new LruCache(10);
    private final JupiterConfiguration configuration;
    private final AbstractOrderingVisitor.DescriptorWrapperOrderer<TestDescriptor, ClassOrderer, DefaultClassDescriptor> globalOrderer;
    private final DiscoveryIssueReporter.Condition<ClassBasedTestDescriptor> noOrderAnnotation;

    ClassOrderingVisitor(JupiterConfiguration configuration, DiscoveryIssueReporter issueReporter) {
        super(issueReporter);
        this.configuration = configuration;
        this.globalOrderer = this.createGlobalOrderer(configuration);
        this.noOrderAnnotation = issueReporter.createReportingCondition(testDescriptor -> !AnnotationSupport.isAnnotated(testDescriptor.getTestClass(), Order.class), testDescriptor -> {
            String message = "Ineffective @Order annotation on class '%s'. It will not be applied because ClassOrderer.OrderAnnotation is not in use. Note that the annotation may be either directly present or meta-present on the class.".formatted(testDescriptor.getTestClass().getName());
            return DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.INFO, (String)message).source(testDescriptor.getSource()).build();
        });
    }

    public void visit(TestDescriptor testDescriptor) {
        this.doWithMatchingDescriptor(JupiterEngineDescriptor.class, testDescriptor, this::orderTopLevelClasses, descriptor -> "Failed to order top-level classes");
        this.doWithMatchingDescriptor(ClassBasedTestDescriptor.class, testDescriptor, this::orderNestedClasses, descriptor -> "Failed to order nested classes for " + String.valueOf(descriptor.getTestClass()));
    }

    @Override
    protected boolean shouldNonMatchingDescriptorsComeBeforeOrderedOnes() {
        return true;
    }

    private void orderTopLevelClasses(JupiterEngineDescriptor engineDescriptor) {
        this.orderChildrenTestDescriptors(engineDescriptor, ClassBasedTestDescriptor.class, this.toValidationAction(this.globalOrderer.getOrderer()), DefaultClassDescriptor::new, this.globalOrderer);
    }

    private void orderNestedClasses(ClassBasedTestDescriptor descriptor) {
        AbstractOrderingVisitor.DescriptorWrapperOrderer<TestDescriptor, ClassOrderer, DefaultClassDescriptor> wrapperOrderer = this.createAndCacheClassLevelOrderer(descriptor);
        this.orderChildrenTestDescriptors(descriptor, ClassBasedTestDescriptor.class, this.toValidationAction(wrapperOrderer.getOrderer()), DefaultClassDescriptor::new, wrapperOrderer);
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<TestDescriptor, ClassOrderer, DefaultClassDescriptor> createGlobalOrderer(JupiterConfiguration configuration) {
        ClassOrderer classOrderer = configuration.getDefaultTestClassOrderer().orElse(null);
        return classOrderer == null ? AbstractOrderingVisitor.DescriptorWrapperOrderer.noop() : this.createDescriptorWrapperOrderer(classOrderer);
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<TestDescriptor, ClassOrderer, DefaultClassDescriptor> createAndCacheClassLevelOrderer(ClassBasedTestDescriptor classBasedTestDescriptor) {
        AbstractOrderingVisitor.DescriptorWrapperOrderer<TestDescriptor, ClassOrderer, DefaultClassDescriptor> orderer = this.createClassLevelOrderer(classBasedTestDescriptor);
        this.ordererCache.put((Object)classBasedTestDescriptor, orderer);
        return orderer;
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<TestDescriptor, ClassOrderer, DefaultClassDescriptor> createClassLevelOrderer(ClassBasedTestDescriptor classBasedTestDescriptor) {
        return AnnotationSupport.findAnnotation(classBasedTestDescriptor.getTestClass(), TestClassOrder.class).map(TestClassOrder::value).map(this::createDescriptorWrapperOrderer).orElseGet(() -> {
            Object parent = classBasedTestDescriptor.getParent().orElse(null);
            if (parent instanceof ClassBasedTestDescriptor) {
                ClassBasedTestDescriptor parentClassTestDescriptor = parent;
                AbstractOrderingVisitor.DescriptorWrapperOrderer<TestDescriptor, ClassOrderer, DefaultClassDescriptor> cacheEntry = (AbstractOrderingVisitor.DescriptorWrapperOrderer<TestDescriptor, ClassOrderer, DefaultClassDescriptor>)this.ordererCache.get((Object)parentClassTestDescriptor);
                return cacheEntry != null ? cacheEntry : this.createClassLevelOrderer(parentClassTestDescriptor);
            }
            return this.globalOrderer;
        });
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<TestDescriptor, ClassOrderer, DefaultClassDescriptor> createDescriptorWrapperOrderer(Class<? extends ClassOrderer> ordererClass) {
        if (ordererClass == ClassOrderer.Default.class) {
            return this.globalOrderer;
        }
        return this.createDescriptorWrapperOrderer((ClassOrderer)ReflectionSupport.newInstance(ordererClass, (Object[])new Object[0]));
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<TestDescriptor, ClassOrderer, DefaultClassDescriptor> createDescriptorWrapperOrderer(ClassOrderer classOrderer) {
        AbstractOrderingVisitor.OrderingAction orderingAction = (__, classDescriptors) -> classOrderer.orderClasses((ClassOrdererContext)new DefaultClassOrdererContext(classDescriptors, this.configuration));
        AbstractOrderingVisitor.MessageGenerator<TestDescriptor> descriptorsAddedMessageGenerator = (parent, number) -> "ClassOrderer [%s] added %d %s which will be ignored.".formatted(classOrderer.getClass().getName(), number, ClassOrderingVisitor.describeClassDescriptors(parent));
        AbstractOrderingVisitor.MessageGenerator<TestDescriptor> descriptorsRemovedMessageGenerator = (parent, number) -> "ClassOrderer [%s] removed %d %s which will be retained with arbitrary ordering.".formatted(classOrderer.getClass().getName(), number, ClassOrderingVisitor.describeClassDescriptors(parent));
        return new AbstractOrderingVisitor.DescriptorWrapperOrderer<TestDescriptor, ClassOrderer, DefaultClassDescriptor>(classOrderer, orderingAction, descriptorsAddedMessageGenerator, descriptorsRemovedMessageGenerator);
    }

    private static String describeClassDescriptors(TestDescriptor parent) {
        String string;
        if (parent instanceof TestClassAware) {
            TestClassAware testClassAware = (TestClassAware)parent;
            string = "nested ClassDescriptor(s) for test class [%s]".formatted(testClassAware.getTestClass().getName());
        } else {
            string = "top-level ClassDescriptor(s)";
        }
        return string;
    }

    private Optional<Consumer<ClassBasedTestDescriptor>> toValidationAction(@Nullable ClassOrderer orderer) {
        if (orderer instanceof ClassOrderer.OrderAnnotation) {
            return Optional.empty();
        }
        return Optional.of(arg_0 -> this.noOrderAnnotation.check(arg_0));
    }
}

