/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;

public class StringMutexLock {
    private final ConcurrentMap<String, CountDownLatch> lockKeyHolder = new ConcurrentHashMap<String, CountDownLatch>();

    public void lock(String lockKey) {
        while (!this.tryLock(lockKey)) {
            try {
                this.blockOnSecondLevelLock(lockKey);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public boolean unlock(String lockKey) {
        CountDownLatch realLock = this.getAndReleaseLock1(lockKey);
        this.releaseSecondLevelLock(realLock);
        return true;
    }

    private boolean tryLock(String lockKey) {
        return this.lockKeyHolder.putIfAbsent(lockKey, new CountDownLatch(1)) == null;
    }

    private CountDownLatch getAndReleaseLock1(String lockKey) {
        return (CountDownLatch)this.lockKeyHolder.remove(lockKey);
    }

    private void blockOnSecondLevelLock(String lockKey) throws InterruptedException {
        CountDownLatch realLock = this.getRealLockByKey(lockKey);
        if (realLock != null) {
            realLock.await();
        }
    }

    private void releaseSecondLevelLock(CountDownLatch realLock) {
        realLock.countDown();
    }

    private CountDownLatch getRealLockByKey(String lockKey) {
        return (CountDownLatch)this.lockKeyHolder.get(lockKey);
    }
}

