/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.runtime;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import org.noear.solon.core.runtime.NativeDetector;

public class AotCollector {
    private final Set<Class<?>> entityTypes = new LinkedHashSet();
    private final Set<Class<?>> jdkProxyTypes = new LinkedHashSet();

    public Set<Class<?>> getEntityTypes() {
        return this.entityTypes;
    }

    public Set<Class<?>> getJdkProxyTypes() {
        return this.jdkProxyTypes;
    }

    public void registerEntityType(Class<?> type, ParameterizedType genericType) {
        if (NativeDetector.isAotRuntime()) {
            if (!type.getName().startsWith("java.")) {
                this.entityTypes.add(type);
            }
            if (genericType != null) {
                for (Type type1 : genericType.getActualTypeArguments()) {
                    if (!(type1 instanceof Class) || type1.getTypeName().startsWith("java.")) continue;
                    this.entityTypes.add((Class)type1);
                }
            }
        }
    }

    public void registerJdkProxyType(Class<?> type, Object target) {
        if (NativeDetector.isAotRuntime() && Proxy.isProxyClass(target.getClass()) && !type.getName().startsWith("java.")) {
            this.jdkProxyTypes.add(type);
        }
    }

    public void clear() {
        this.entityTypes.clear();
        this.jdkProxyTypes.clear();
    }
}

