/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.pkg.container;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.ofdrw.core.signatures.Signatures;
import org.ofdrw.pkg.container.SignDir;
import org.ofdrw.pkg.container.VirtualContainer;

public class SignsDir
extends VirtualContainer {
    private int maxSignIndex = 0;
    public static final String SignaturesFileName = "Signatures.xml";

    public SignsDir(Path fullDir) throws IllegalArgumentException {
        super(fullDir);
        this.initContainer();
    }

    private void initContainer() {
        File fullDirFile = new File(this.getSysAbsPath());
        File[] files = fullDirFile.listFiles();
        if (files != null) {
            for (File f : files) {
                String numb;
                int num;
                String dirName = f.getName();
                if (!dirName.startsWith("Sign_") || this.maxSignIndex > (num = Integer.parseInt(numb = dirName.replace("Sign_", "")))) continue;
                this.maxSignIndex = num + 1;
            }
        }
    }

    public Signatures getSignatures() throws FileNotFoundException, DocumentException {
        Element element = this.getObj(SignaturesFileName);
        return new Signatures(element);
    }

    public SignsDir setSignatures(Signatures signatures) {
        this.putObj(SignaturesFileName, (Element)signatures);
        return this;
    }

    public SignDir newSignDir() {
        String name = "Sign_" + this.maxSignIndex;
        ++this.maxSignIndex;
        return this.obtainContainer(name, SignDir::new);
    }

    public SignDir getByIndex(Integer index) throws FileNotFoundException {
        if (index == null || index <= 0) {
            throw new NumberFormatException("\u7b7e\u540d\u5bb9\u5668index\u5fc5\u987b\u5927\u4e8e0");
        }
        String containerName = "Sign_" + index;
        return this.getContainer(containerName, SignDir::new);
    }

    public SignDir getSignDir(String containerName) throws FileNotFoundException {
        return this.getContainer(containerName, SignDir::new);
    }
}

