/*
 * Decompiled with CFR 0.152.
 */
package lombok.maven;

import java.io.File;
import java.io.IOException;
import java.nio.charset.UnsupportedCharsetException;
import lombok.delombok.Delombok;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class DelombokMojo
extends AbstractMojo {
    private boolean skip;
    private String encoding;
    private File sourceDirectory;
    private File outputDirectory;
    private boolean verbose;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Log logger = this.getLog();
        assert (null != logger);
        if (this.skip) {
            logger.warn((CharSequence)"Skipping delombok.");
        } else {
            if (this.sourceDirectory.exists()) {
                Delombok delombok = new Delombok();
                delombok.setVerbose(this.verbose);
                try {
                    delombok.setCharset(this.encoding);
                }
                catch (UnsupportedCharsetException e) {
                    logger.error((CharSequence)"The encoding parameter is invalid; Please check!", (Throwable)e);
                    throw new MojoExecutionException("Unknown charset: " + this.encoding, (Exception)e);
                }
                try {
                    delombok.setOutput(this.outputDirectory);
                    delombok.delombok(this.sourceDirectory);
                    logger.info((CharSequence)"Delombok complete.");
                    this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
                }
                catch (IOException e) {
                    logger.error((CharSequence)"Unable to delombok!", (Throwable)e);
                    throw new MojoExecutionException("I/O problem during delombok", (Exception)e);
                }
            }
            logger.warn((CharSequence)"Skipping delombok; no source to process.");
        }
    }
}

