/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl;

import java.util.ArrayList;
import java.util.List;

public class SimplePatternFormatter {
    private final String patternWithoutPlaceholders;
    private final int placeholderCount;
    private final int[] placeholderIdsOrderedByOffset;
    private final boolean firstPlaceholderReused;

    private SimplePatternFormatter(String pattern, PlaceholdersBuilder builder) {
        this.patternWithoutPlaceholders = pattern;
        this.placeholderIdsOrderedByOffset = builder.getPlaceholderIdsOrderedByOffset();
        this.placeholderCount = builder.getPlaceholderCount();
        this.firstPlaceholderReused = builder.getFirstPlaceholderReused();
    }

    public static SimplePatternFormatter compile(String pattern) {
        PlaceholdersBuilder placeholdersBuilder = new PlaceholdersBuilder();
        PlaceholderIdBuilder idBuilder = new PlaceholderIdBuilder();
        StringBuilder newPattern = new StringBuilder();
        State state = State.INIT;
        block10: for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            switch (state) {
                case INIT: {
                    if (ch == '\'') {
                        state = State.APOSTROPHE;
                        continue block10;
                    }
                    if (ch == '{') {
                        state = State.PLACEHOLDER;
                        idBuilder.reset();
                        continue block10;
                    }
                    newPattern.append(ch);
                    continue block10;
                }
                case APOSTROPHE: {
                    if (ch == '\'') {
                        newPattern.append("'");
                    } else if (ch == '{') {
                        newPattern.append("{");
                    } else {
                        newPattern.append("'");
                        newPattern.append(ch);
                    }
                    state = State.INIT;
                    continue block10;
                }
                case PLACEHOLDER: {
                    if (ch >= '0' && ch <= '9') {
                        idBuilder.add(ch);
                        continue block10;
                    }
                    if (ch == '}' && idBuilder.isValid()) {
                        placeholdersBuilder.add(idBuilder.getId(), newPattern.length());
                        state = State.INIT;
                        continue block10;
                    }
                    newPattern.append('{');
                    idBuilder.appendTo(newPattern);
                    newPattern.append(ch);
                    state = State.INIT;
                    continue block10;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        switch (state) {
            case INIT: {
                break;
            }
            case APOSTROPHE: {
                newPattern.append("'");
                break;
            }
            case PLACEHOLDER: {
                newPattern.append('{');
                idBuilder.appendTo(newPattern);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return new SimplePatternFormatter(newPattern.toString(), placeholdersBuilder);
    }

    public int getPlaceholderCount() {
        return this.placeholderCount;
    }

    public String format(CharSequence ... values) {
        return this.formatAndAppend(new StringBuilder(), null, values).toString();
    }

    public StringBuilder formatAndAppend(StringBuilder appendTo, int[] offsets, CharSequence ... values) {
        if (values.length < this.placeholderCount) {
            throw new IllegalArgumentException("Too few values.");
        }
        PlaceholderValues placeholderValues = new PlaceholderValues(values);
        if (placeholderValues.isAppendToInAnyIndexExcept(appendTo, -1)) {
            throw new IllegalArgumentException("Parameter values cannot be the same as appendTo.");
        }
        this.formatReturningOffsetLength(appendTo, offsets, placeholderValues);
        return appendTo;
    }

    public StringBuilder formatAndReplace(StringBuilder result, int[] offsets, CharSequence ... values) {
        if (values.length < this.placeholderCount) {
            throw new IllegalArgumentException("Too few values.");
        }
        PlaceholderValues placeholderValues = new PlaceholderValues(values);
        int placeholderAtStart = this.getUniquePlaceholderAtStart();
        if (placeholderAtStart >= 0 && values[placeholderAtStart] == result) {
            if (placeholderValues.isAppendToInAnyIndexExcept(result, placeholderAtStart)) {
                placeholderValues.snapshotAppendTo(result);
                result.setLength(0);
                this.formatReturningOffsetLength(result, offsets, placeholderValues);
                return result;
            }
            int offsetLength = this.formatReturningOffsetLength(result, offsets, placeholderValues);
            if (offsetLength > placeholderAtStart) {
                offsets[placeholderAtStart] = 0;
            }
            return result;
        }
        if (placeholderValues.isAppendToInAnyIndexExcept(result, -1)) {
            placeholderValues.snapshotAppendTo(result);
        }
        result.setLength(0);
        this.formatReturningOffsetLength(result, offsets, placeholderValues);
        return result;
    }

    public String toString() {
        CharSequence[] values = new String[this.getPlaceholderCount()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = String.format("{%d}", i);
        }
        return this.formatAndAppend(new StringBuilder(), null, values).toString();
    }

    public String getPatternWithNoPlaceholders() {
        return this.patternWithoutPlaceholders;
    }

    private int formatReturningOffsetLength(StringBuilder appendTo, int[] offsets, PlaceholderValues values) {
        int offsetLen = offsets == null ? 0 : offsets.length;
        for (int i = 0; i < offsetLen; ++i) {
            offsets[i] = -1;
        }
        if (this.placeholderIdsOrderedByOffset.length == 0) {
            appendTo.append(this.patternWithoutPlaceholders);
            return offsetLen;
        }
        appendTo.append(this.patternWithoutPlaceholders, 0, this.placeholderIdsOrderedByOffset[0]);
        SimplePatternFormatter.setPlaceholderOffset(this.placeholderIdsOrderedByOffset[1], appendTo.length(), offsets, offsetLen);
        CharSequence placeholderValue = values.get(this.placeholderIdsOrderedByOffset[1]);
        if (placeholderValue != appendTo) {
            appendTo.append(placeholderValue);
        }
        for (int i = 2; i < this.placeholderIdsOrderedByOffset.length; i += 2) {
            appendTo.append(this.patternWithoutPlaceholders, this.placeholderIdsOrderedByOffset[i - 2], this.placeholderIdsOrderedByOffset[i]);
            SimplePatternFormatter.setPlaceholderOffset(this.placeholderIdsOrderedByOffset[i + 1], appendTo.length(), offsets, offsetLen);
            placeholderValue = values.get(this.placeholderIdsOrderedByOffset[i + 1]);
            if (placeholderValue == appendTo) continue;
            appendTo.append(placeholderValue);
        }
        appendTo.append(this.patternWithoutPlaceholders, this.placeholderIdsOrderedByOffset[this.placeholderIdsOrderedByOffset.length - 2], this.patternWithoutPlaceholders.length());
        return offsetLen;
    }

    private int getUniquePlaceholderAtStart() {
        if (this.placeholderIdsOrderedByOffset.length == 0 || this.firstPlaceholderReused || this.placeholderIdsOrderedByOffset[0] != 0) {
            return -1;
        }
        return this.placeholderIdsOrderedByOffset[1];
    }

    private static void setPlaceholderOffset(int placeholderId, int offset, int[] offsets, int offsetLen) {
        if (placeholderId < offsetLen) {
            offsets[placeholderId] = offset;
        }
    }

    private static class PlaceholderValues {
        private final CharSequence[] values;
        private CharSequence appendTo;
        private String appendToCopy;

        public PlaceholderValues(CharSequence ... values) {
            this.values = values;
            this.appendTo = null;
            this.appendToCopy = null;
        }

        public boolean isAppendToInAnyIndexExcept(CharSequence appendTo, int exceptIndex) {
            for (int i = 0; i < this.values.length; ++i) {
                if (i == exceptIndex || this.values[i] != appendTo) continue;
                return true;
            }
            return false;
        }

        public void snapshotAppendTo(CharSequence appendTo) {
            this.appendTo = appendTo;
            this.appendToCopy = appendTo.toString();
        }

        public CharSequence get(int index) {
            if (this.appendTo == null || this.appendTo != this.values[index]) {
                return this.values[index];
            }
            return this.appendToCopy;
        }
    }

    private static class PlaceholdersBuilder {
        private List<Integer> placeholderIdsOrderedByOffset = new ArrayList<Integer>();
        private int placeholderCount = 0;
        private boolean firstPlaceholderReused = false;

        private PlaceholdersBuilder() {
        }

        public void add(int placeholderId, int offset) {
            int len;
            this.placeholderIdsOrderedByOffset.add(offset);
            this.placeholderIdsOrderedByOffset.add(placeholderId);
            if (placeholderId >= this.placeholderCount) {
                this.placeholderCount = placeholderId + 1;
            }
            if ((len = this.placeholderIdsOrderedByOffset.size()) > 2 && this.placeholderIdsOrderedByOffset.get(len - 1).equals(this.placeholderIdsOrderedByOffset.get(1))) {
                this.firstPlaceholderReused = true;
            }
        }

        public int getPlaceholderCount() {
            return this.placeholderCount;
        }

        public int[] getPlaceholderIdsOrderedByOffset() {
            int[] result = new int[this.placeholderIdsOrderedByOffset.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.placeholderIdsOrderedByOffset.get(i);
            }
            return result;
        }

        public boolean getFirstPlaceholderReused() {
            return this.firstPlaceholderReused;
        }
    }

    private static class PlaceholderIdBuilder {
        private int id = 0;
        private int idLen = 0;

        private PlaceholderIdBuilder() {
        }

        public void reset() {
            this.id = 0;
            this.idLen = 0;
        }

        public int getId() {
            return this.id;
        }

        public void appendTo(StringBuilder appendTo) {
            if (this.idLen > 0) {
                appendTo.append(this.id);
            }
        }

        public boolean isValid() {
            return this.idLen > 0;
        }

        public void add(char ch) {
            this.id = this.id * 10 + ch - 48;
            ++this.idLen;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INIT,
        APOSTROPHE,
        PLACEHOLDER;

    }
}

