/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProduceException;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducer;

class MimeMessageProducerMixedAlternative
extends MimeMessageProducer {
    MimeMessageProducerMixedAlternative() {
    }

    @Override
    boolean compatibleWithEmail(@NotNull Email email) {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageProducerMixedAlternative.compatibleWithEmail must not be null");
        }
        return MimeMessageProducerMixedAlternative.emailContainsMixedContent(email) && !MimeMessageProducerMixedAlternative.emailContainsRelatedContent(email) && MimeMessageProducerMixedAlternative.emailContainsAlternativeContent(email);
    }

    @Override
    void populateMimeMessageMultipartStructure(@NotNull MimeMessage message, @NotNull Email email) throws MessagingException {
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageProducerMixedAlternative.populateMimeMessageMultipartStructure must not be null");
        }
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/internal/mimemessage/MimeMessageProducerMixedAlternative.populateMimeMessageMultipartStructure must not be null");
        }
        MultipartStructureWrapper multipartStructureWrapper = new MultipartStructureWrapper();
        MimeMessageHelper.setTexts(email, multipartStructureWrapper.multipartAlternativeMessages);
        MimeMessageHelper.configureForwarding(email, multipartStructureWrapper.multipartRootMixed);
        MimeMessageHelper.setAttachments(email, multipartStructureWrapper.multipartRootMixed);
        message.setContent((Multipart)multipartStructureWrapper.multipartRootMixed);
    }

    private static class MultipartStructureWrapper {
        private final MimeMultipart multipartRootMixed = new MimeMultipart("mixed");
        private final MimeMultipart multipartAlternativeMessages;

        private MultipartStructureWrapper() {
            MimeBodyPart contentAlternativeMessages = new MimeBodyPart();
            this.multipartAlternativeMessages = new MimeMultipart("alternative");
            try {
                this.multipartRootMixed.addBodyPart((BodyPart)contentAlternativeMessages);
                contentAlternativeMessages.setContent((Multipart)this.multipartAlternativeMessages);
            }
            catch (MessagingException e) {
                throw new MimeMessageProduceException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

