/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.mailer.CustomMailer;
import org.simplejavamail.api.mailer.config.LoadBalancingStrategy;
import org.simplejavamail.api.mailer.config.OperationalConfig;

class OperationalConfigImpl
implements OperationalConfig {
    private final int sessionTimeout;
    private final boolean async;
    private final Properties properties;
    private final int threadPoolSize;
    private final int threadPoolKeepAliveTime;
    @NotNull
    private final UUID clusterKey;
    private final int connectionPoolCoreSize;
    private final int connectionPoolMaxSize;
    private final int connectionPoolClaimTimeoutMillis;
    private final int connectionPoolExpireAfterMillis;
    @NotNull
    private final LoadBalancingStrategy connectionPoolLoadBalancingStrategy;
    private final boolean transportModeLoggingOnly;
    private final boolean debugLogging;
    @NotNull
    private final List<String> sslHostsToTrust;
    private final boolean trustAllSSLHost;
    private final boolean verifyingServerIdentity;
    @NotNull
    private final ExecutorService executorService;
    @Nullable
    private final CustomMailer customMailer;

    OperationalConfigImpl(boolean async, @Nullable Properties properties, int sessionTimeout, int threadPoolSize, int threadPoolKeepAliveTime, @NotNull UUID clusterKey, int connectionPoolCoreSize, int connectionPoolMaxSize, int connectionPoolClaimTimeoutMillis, int connectionPoolExpireAfterMillis, @NotNull LoadBalancingStrategy connectionPoolLoadBalancingStrategy, boolean transportModeLoggingOnly, boolean debugLogging, @NotNull List<String> sslHostsToTrust, boolean trustAllSSLHost, boolean verifyingServerIdentity, @NotNull ExecutorService executorService, @Nullable CustomMailer customMailer) {
        if (clusterKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 5 of org/simplejavamail/mailer/internal/OperationalConfigImpl.<init> must not be null");
        }
        if (connectionPoolLoadBalancingStrategy == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 10 of org/simplejavamail/mailer/internal/OperationalConfigImpl.<init> must not be null");
        }
        if (sslHostsToTrust == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 13 of org/simplejavamail/mailer/internal/OperationalConfigImpl.<init> must not be null");
        }
        if (executorService == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 16 of org/simplejavamail/mailer/internal/OperationalConfigImpl.<init> must not be null");
        }
        this.async = async;
        this.properties = properties;
        this.sessionTimeout = sessionTimeout;
        this.threadPoolSize = threadPoolSize;
        this.threadPoolKeepAliveTime = threadPoolKeepAliveTime;
        this.clusterKey = clusterKey;
        this.connectionPoolCoreSize = connectionPoolCoreSize;
        this.connectionPoolMaxSize = connectionPoolMaxSize;
        this.connectionPoolClaimTimeoutMillis = connectionPoolClaimTimeoutMillis;
        this.connectionPoolExpireAfterMillis = connectionPoolExpireAfterMillis;
        this.connectionPoolLoadBalancingStrategy = connectionPoolLoadBalancingStrategy;
        this.transportModeLoggingOnly = transportModeLoggingOnly;
        this.debugLogging = debugLogging;
        this.sslHostsToTrust = Collections.unmodifiableList(sslHostsToTrust);
        this.trustAllSSLHost = trustAllSSLHost;
        this.verifyingServerIdentity = verifyingServerIdentity;
        this.executorService = executorService;
        this.customMailer = customMailer;
    }

    public String toString() {
        String string = "OperationalConfigImpl{async=" + this.async + ", properties=" + this.properties + ", sessionTimeout=" + this.sessionTimeout + ", threadPoolSize=" + this.threadPoolSize + ", threadPoolKeepAliveTime=" + this.threadPoolKeepAliveTime + ", clusterKey=" + this.clusterKey + ", connectionPoolCoreSize=" + this.connectionPoolCoreSize + ", connectionPoolMaxSize=" + this.connectionPoolMaxSize + ", connectionPoolClaimTimeoutMillis=" + this.connectionPoolClaimTimeoutMillis + ", connectionPoolExpireAfterMillis=" + this.connectionPoolExpireAfterMillis + ", connectionPoolLoadBalancingStrategy=" + this.connectionPoolLoadBalancingStrategy + ", transportModeLoggingOnly=" + this.transportModeLoggingOnly + ", debugLogging=" + this.debugLogging + ", sslHostsToTrust=" + this.sslHostsToTrust + ", trustAllSSLHost=" + this.trustAllSSLHost + ", verifyingServerIdentity=" + this.verifyingServerIdentity + ", executorService=" + this.executorService + ", customMailer=" + this.customMailer + '}';
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/OperationalConfigImpl.toString must not return null");
        }
        return string;
    }

    public boolean isAsync() {
        return this.async;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getThreadPoolKeepAliveTime() {
        return this.threadPoolKeepAliveTime;
    }

    public int getConnectionPoolCoreSize() {
        return this.connectionPoolCoreSize;
    }

    public int getConnectionPoolMaxSize() {
        return this.connectionPoolMaxSize;
    }

    public int getConnectionPoolClaimTimeoutMillis() {
        return this.connectionPoolClaimTimeoutMillis;
    }

    public int getConnectionPoolExpireAfterMillis() {
        return this.connectionPoolExpireAfterMillis;
    }

    @NotNull
    public LoadBalancingStrategy getConnectionPoolLoadBalancingStrategy() {
        LoadBalancingStrategy loadBalancingStrategy = this.connectionPoolLoadBalancingStrategy;
        if (loadBalancingStrategy == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/OperationalConfigImpl.getConnectionPoolLoadBalancingStrategy must not return null");
        }
        return loadBalancingStrategy;
    }

    public boolean isTransportModeLoggingOnly() {
        return this.transportModeLoggingOnly;
    }

    public boolean isDebugLogging() {
        return this.debugLogging;
    }

    @NotNull
    public List<String> getSslHostsToTrust() {
        List<String> list = this.sslHostsToTrust;
        if (list == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/OperationalConfigImpl.getSslHostsToTrust must not return null");
        }
        return list;
    }

    public boolean isTrustAllSSLHost() {
        return this.trustAllSSLHost;
    }

    public boolean isVerifyingServerIdentity() {
        return this.verifyingServerIdentity;
    }

    @NotNull
    public Properties getProperties() {
        Properties properties = this.properties;
        if (properties == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/OperationalConfigImpl.getProperties must not return null");
        }
        return properties;
    }

    @NotNull
    public UUID getClusterKey() {
        UUID uUID = this.clusterKey;
        if (uUID == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/OperationalConfigImpl.getClusterKey must not return null");
        }
        return uUID;
    }

    @NotNull
    public ExecutorService getExecutorService() {
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/OperationalConfigImpl.getExecutorService must not return null");
        }
        return executorService;
    }

    @Nullable
    public CustomMailer getCustomMailer() {
        return this.customMailer;
    }
}

