/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.core.properties.SwaggerUiOAuthProperties;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.ui.AbstractSwaggerIndexTransformer;
import org.springdoc.ui.SpringDocUIException;
import org.springdoc.webflux.ui.SwaggerIndexTransformer;
import org.springdoc.webflux.ui.SwaggerWelcomeCommon;
import org.springframework.core.io.Resource;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.reactive.resource.TransformedResource;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SwaggerIndexPageTransformer
extends AbstractSwaggerIndexTransformer
implements SwaggerIndexTransformer {
    private final SwaggerWelcomeCommon swaggerWelcomeCommon;

    public SwaggerIndexPageTransformer(SwaggerUiConfigProperties swaggerUiConfig, SwaggerUiOAuthProperties swaggerUiOAuthProperties, SwaggerUiConfigParameters swaggerUiConfigParameters, SwaggerWelcomeCommon swaggerWelcomeCommon, ObjectMapperProvider objectMapperProvider) {
        super(swaggerUiConfig, swaggerUiOAuthProperties, swaggerUiConfigParameters, objectMapperProvider);
        this.swaggerWelcomeCommon = swaggerWelcomeCommon;
    }

    public Mono<Resource> transform(ServerWebExchange serverWebExchange, Resource resource, ResourceTransformerChain resourceTransformerChain) {
        if (this.swaggerUiConfigParameters.getConfigUrl() == null) {
            this.swaggerWelcomeCommon.buildFromCurrentContextPath(serverWebExchange.getRequest());
        }
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        try {
            boolean isIndexFound = antPathMatcher.match("**/swagger-ui/**/swagger-initializer.js", resource.getURL().toString());
            if (isIndexFound) {
                String html = this.defaultTransformations(resource.getInputStream());
                return Mono.just((Object)new TransformedResource(resource, html.getBytes()));
            }
            return Mono.just((Object)resource);
        }
        catch (Exception e) {
            throw new SpringDocUIException("Failed to transform Index", (Throwable)e);
        }
    }
}

