/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.runner;

import jakarta.servlet.ServletContext;
import java.util.function.Supplier;
import org.springframework.boot.test.context.assertj.AssertableWebApplicationContext;
import org.springframework.boot.test.context.runner.AbstractApplicationContextRunner;
import org.springframework.boot.web.context.servlet.AnnotationConfigServletWebApplicationContext;
import org.springframework.mock.web.MockServletContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public final class WebApplicationContextRunner
extends AbstractApplicationContextRunner<WebApplicationContextRunner, ConfigurableWebApplicationContext, AssertableWebApplicationContext> {
    public WebApplicationContextRunner() {
        this(WebApplicationContextRunner.withMockServletContext(AnnotationConfigServletWebApplicationContext::new));
    }

    public WebApplicationContextRunner(Supplier<ConfigurableWebApplicationContext> contextFactory) {
        super(WebApplicationContextRunner::new, contextFactory, new Class[0]);
    }

    public WebApplicationContextRunner(Supplier<ConfigurableWebApplicationContext> contextFactory, Class<?> ... additionalContextInterfaces) {
        super(WebApplicationContextRunner::new, contextFactory, additionalContextInterfaces);
    }

    private WebApplicationContextRunner(AbstractApplicationContextRunner.RunnerConfiguration<ConfigurableWebApplicationContext> configuration) {
        super(configuration, WebApplicationContextRunner::new);
    }

    public static Supplier<ConfigurableWebApplicationContext> withMockServletContext(Supplier<ConfigurableWebApplicationContext> contextFactory) {
        return contextFactory != null ? () -> {
            ConfigurableWebApplicationContext context = (ConfigurableWebApplicationContext)contextFactory.get();
            context.setServletContext((ServletContext)new MockServletContext());
            return context;
        } : null;
    }
}

