/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.client;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.http.client.AbstractClientHttpRequestFactoryWrapper;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class ClientHttpRequestFactoriesRuntimeHints
implements RuntimeHintsRegistrar {
    ClientHttpRequestFactoriesRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        if (ClassUtils.isPresent((String)"org.springframework.http.client.ClientHttpRequestFactory", (ClassLoader)classLoader)) {
            this.registerHints(hints.reflection(), classLoader);
        }
    }

    private void registerHints(ReflectionHints hints, ClassLoader classLoader) {
        hints.registerField(this.findField(AbstractClientHttpRequestFactoryWrapper.class, "requestFactory"));
        hints.registerTypeIfPresent(classLoader, "org.apache.hc.client5.http.impl.classic.HttpClients", typeHint -> {
            typeHint.onReachableType(TypeReference.of((String)"org.apache.hc.client5.http.impl.classic.HttpClients"));
            this.registerReflectionHints(hints, HttpComponentsClientHttpRequestFactory.class);
        });
        hints.registerTypeIfPresent(classLoader, "okhttp3.OkHttpClient", typeHint -> {
            typeHint.onReachableType(TypeReference.of((String)"okhttp3.OkHttpClient"));
            this.registerReflectionHints(hints, OkHttp3ClientHttpRequestFactory.class);
        });
        hints.registerType(SimpleClientHttpRequestFactory.class, typeHint -> {
            typeHint.onReachableType(HttpURLConnection.class);
            this.registerReflectionHints(hints, SimpleClientHttpRequestFactory.class);
        });
    }

    private void registerReflectionHints(ReflectionHints hints, Class<? extends ClientHttpRequestFactory> requestFactoryType) {
        this.registerMethod(hints, requestFactoryType, "setConnectTimeout", Integer.TYPE);
        this.registerMethod(hints, requestFactoryType, "setReadTimeout", Integer.TYPE);
        this.registerMethod(hints, requestFactoryType, "setBufferRequestBody", Boolean.TYPE);
    }

    private void registerMethod(ReflectionHints hints, Class<? extends ClientHttpRequestFactory> requestFactoryType, String methodName, Class<?> ... parameterTypes) {
        Method method = ReflectionUtils.findMethod(requestFactoryType, (String)methodName, (Class[])parameterTypes);
        if (method != null) {
            hints.registerMethod(method, ExecutableMode.INVOKE);
        }
    }

    private Field findField(Class<?> type, String name) {
        Field field = ReflectionUtils.findField(type, (String)name);
        Assert.state((field != null ? 1 : 0) != 0, () -> "Unable to find field '%s' on %s".formatted(type.getName(), name));
        return field;
    }
}

