/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import java.time.temporal.TemporalAccessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.convert.AbstractRangePropertyValueConverter;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchDateConverter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.util.Assert;

public class TemporalRangePropertyValueConverter
extends AbstractRangePropertyValueConverter<TemporalAccessor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemporalRangePropertyValueConverter.class);
    private final List<ElasticsearchDateConverter> dateConverters;

    public TemporalRangePropertyValueConverter(PersistentProperty<?> property, List<ElasticsearchDateConverter> dateConverters) {
        super(property);
        Assert.notEmpty(dateConverters, (String)"dateConverters must not be empty.");
        this.dateConverters = dateConverters;
    }

    @Override
    protected String format(TemporalAccessor temporal) {
        return this.dateConverters.get(0).format(temporal);
    }

    @Override
    protected TemporalAccessor parse(String value) {
        Class<?> type = this.getGenericType();
        for (ElasticsearchDateConverter converters : this.dateConverters) {
            try {
                return converters.parse(value, type);
            }
            catch (Exception e) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
            }
        }
        throw new ConversionException(String.format("Unable to convert value '%s' to %s for property '%s'", value, type.getTypeName(), this.getProperty().getName()));
    }
}

