/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchHitsIterator;
import org.springframework.data.elasticsearch.core.SearchPage;
import org.springframework.data.repository.util.ReactiveWrappers;
import org.springframework.data.util.CloseableIterator;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;

public final class SearchHitSupport {
    private SearchHitSupport() {
    }

    @Nullable
    public static Object unwrapSearchHits(@Nullable Object result) {
        if (result == null) {
            return result;
        }
        if (result instanceof SearchHit) {
            return ((SearchHit)result).getContent();
        }
        if (result instanceof List) {
            return ((List)result).stream().map(SearchHitSupport::unwrapSearchHits).collect(Collectors.toList());
        }
        if (result instanceof Stream) {
            return ((Stream)result).map(SearchHitSupport::unwrapSearchHits);
        }
        if (result instanceof SearchHits) {
            SearchHits searchHits = (SearchHits)result;
            return SearchHitSupport.unwrapSearchHits(searchHits.getSearchHits());
        }
        if (result instanceof SearchHitsIterator) {
            return SearchHitSupport.unwrapSearchHitsIterator((SearchHitsIterator)result);
        }
        if (result instanceof SearchPage) {
            SearchPage searchPage = (SearchPage)result;
            List content = (List)SearchHitSupport.unwrapSearchHits(searchPage.getSearchHits());
            return new PageImpl(content, searchPage.getPageable(), searchPage.getTotalElements());
        }
        if (ReactiveWrappers.isAvailable((ReactiveWrappers.ReactiveLibrary)ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR) && result instanceof Flux) {
            Flux flux = (Flux)result;
            return flux.map(SearchHitSupport::unwrapSearchHits);
        }
        return result;
    }

    private static CloseableIterator<?> unwrapSearchHitsIterator(final SearchHitsIterator<?> iterator) {
        return new CloseableIterator<Object>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                return SearchHitSupport.unwrapSearchHits(iterator.next());
            }

            public void close() {
                iterator.close();
            }
        };
    }

    public static <T> SearchPage<T> searchPageFor(SearchHits<T> searchHits, @Nullable Pageable pageable) {
        return new SearchPageImpl<T>(searchHits, pageable != null ? pageable : Pageable.unpaged());
    }

    static class SearchPageImpl<T>
    extends PageImpl<SearchHit<T>>
    implements SearchPage<T> {
        private final SearchHits<T> searchHits;

        public SearchPageImpl(SearchHits<T> searchHits, Pageable pageable) {
            super(searchHits.getSearchHits(), pageable, searchHits.getTotalHits());
            this.searchHits = searchHits;
        }

        @Override
        public SearchHits<T> getSearchHits() {
            return this.searchHits;
        }

        public List<SearchHit<T>> getContent() {
            return this.searchHits.getSearchHits();
        }
    }
}

