/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.geo;

import java.util.Arrays;
import java.util.List;
import org.springframework.data.elasticsearch.core.geo.GeoJson;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.geo.Point;

public class GeoJsonPoint
implements GeoJson<List<Double>> {
    private final double x;
    private final double y;
    public static final String TYPE = "Point";

    private GeoJsonPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static GeoJsonPoint of(double x, double y) {
        return new GeoJsonPoint(x, y);
    }

    public static GeoJsonPoint of(Point point) {
        return new GeoJsonPoint(point.getX(), point.getY());
    }

    public static GeoJsonPoint of(GeoPoint geoPoint) {
        return new GeoJsonPoint(geoPoint.getLon(), geoPoint.getLat());
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    @Override
    public List<Double> getCoordinates() {
        return Arrays.asList(this.getX(), this.getY());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoJsonPoint that = (GeoJsonPoint)o;
        if (Double.compare(that.x, this.x) != 0) {
            return false;
        }
        return Double.compare(that.y, this.y) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoJsonPoint{x=" + this.x + ", y=" + this.y + "}";
    }
}

