/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.support.PersistentEntityInformation;

public class MappingElasticsearchEntityInformation<T, ID>
extends PersistentEntityInformation<T, ID>
implements ElasticsearchEntityInformation<T, ID> {
    private final ElasticsearchPersistentEntity<T> persistentEntity;

    public MappingElasticsearchEntityInformation(ElasticsearchPersistentEntity<T> persistentEntity) {
        super(persistentEntity);
        this.persistentEntity = persistentEntity;
    }

    @Override
    public String getIdAttribute() {
        return ((ElasticsearchPersistentProperty)this.persistentEntity.getRequiredIdProperty()).getFieldName();
    }

    @Override
    public IndexCoordinates getIndexCoordinates() {
        return this.persistentEntity.getIndexCoordinates();
    }

    @Override
    public Long getVersion(T entity) {
        ElasticsearchPersistentProperty versionProperty = this.persistentEntity.getVersionProperty();
        try {
            return versionProperty != null ? (Long)this.persistentEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)versionProperty) : null;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to load version field", e);
        }
    }

    @Override
    public Document.VersionType getVersionType() {
        return this.persistentEntity.getVersionType();
    }
}

