/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ReactiveSubscription;
import org.springframework.data.redis.core.ReactiveGeoOperations;
import org.springframework.data.redis.core.ReactiveHashOperations;
import org.springframework.data.redis.core.ReactiveHyperLogLogOperations;
import org.springframework.data.redis.core.ReactiveListOperations;
import org.springframework.data.redis.core.ReactiveRedisCallback;
import org.springframework.data.redis.core.ReactiveSetOperations;
import org.springframework.data.redis.core.ReactiveStreamOperations;
import org.springframework.data.redis.core.ReactiveValueOperations;
import org.springframework.data.redis.core.ReactiveZSetOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.serializer.RedisElementReader;
import org.springframework.data.redis.serializer.RedisElementWriter;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveRedisOperations<K, V> {
    public <T> Flux<T> execute(ReactiveRedisCallback<T> var1);

    public Mono<Long> convertAndSend(String var1, V var2);

    default public Flux<? extends ReactiveSubscription.Message<String, V>> listenToChannel(String ... channels) {
        Assert.notNull((Object)channels, (String)"Channels must not be null!");
        return this.listenTo((Topic[])Arrays.stream(channels).map(ChannelTopic::of).toArray(ChannelTopic[]::new));
    }

    default public Flux<? extends ReactiveSubscription.Message<String, V>> listenToPattern(String ... patterns) {
        Assert.notNull((Object)patterns, (String)"Patterns must not be null!");
        return this.listenTo((Topic[])Arrays.stream(patterns).map(PatternTopic::of).toArray(PatternTopic[]::new));
    }

    public Flux<? extends ReactiveSubscription.Message<String, V>> listenTo(Topic ... var1);

    public Mono<Boolean> hasKey(K var1);

    public Mono<DataType> type(K var1);

    public Flux<K> keys(K var1);

    default public Flux<K> scan() {
        return this.scan(ScanOptions.NONE);
    }

    public Flux<K> scan(ScanOptions var1);

    public Mono<K> randomKey();

    public Mono<Boolean> rename(K var1, K var2);

    public Mono<Boolean> renameIfAbsent(K var1, K var2);

    public Mono<Long> delete(K ... var1);

    public Mono<Long> delete(Publisher<K> var1);

    public Mono<Long> unlink(K ... var1);

    public Mono<Long> unlink(Publisher<K> var1);

    public Mono<Boolean> expire(K var1, Duration var2);

    public Mono<Boolean> expireAt(K var1, Instant var2);

    public Mono<Boolean> persist(K var1);

    public Mono<Boolean> move(K var1, int var2);

    public Mono<Duration> getExpire(K var1);

    default public <T> Flux<T> execute(RedisScript<T> script) {
        return this.execute(script, Collections.emptyList());
    }

    default public <T> Flux<T> execute(RedisScript<T> script, List<K> keys) {
        return this.execute(script, keys, Collections.emptyList());
    }

    public <T> Flux<T> execute(RedisScript<T> var1, List<K> var2, List<?> var3);

    public <T> Flux<T> execute(RedisScript<T> var1, List<K> var2, List<?> var3, RedisElementWriter<?> var4, RedisElementReader<T> var5);

    public ReactiveGeoOperations<K, V> opsForGeo();

    public <K, V> ReactiveGeoOperations<K, V> opsForGeo(RedisSerializationContext<K, V> var1);

    public <HK, HV> ReactiveHashOperations<K, HK, HV> opsForHash();

    public <K, HK, HV> ReactiveHashOperations<K, HK, HV> opsForHash(RedisSerializationContext<K, ?> var1);

    public ReactiveHyperLogLogOperations<K, V> opsForHyperLogLog();

    public <K, V> ReactiveHyperLogLogOperations<K, V> opsForHyperLogLog(RedisSerializationContext<K, V> var1);

    public ReactiveListOperations<K, V> opsForList();

    public <K, V> ReactiveListOperations<K, V> opsForList(RedisSerializationContext<K, V> var1);

    public ReactiveSetOperations<K, V> opsForSet();

    public <K, V> ReactiveSetOperations<K, V> opsForSet(RedisSerializationContext<K, V> var1);

    public <HK, HV> ReactiveStreamOperations<K, HK, HV> opsForStream();

    public <HK, HV> ReactiveStreamOperations<K, HK, HV> opsForStream(HashMapper<? super K, ? super HK, ? super HV> var1);

    public <HK, HV> ReactiveStreamOperations<K, HK, HV> opsForStream(RedisSerializationContext<K, ?> var1);

    public ReactiveValueOperations<K, V> opsForValue();

    public <K, V> ReactiveValueOperations<K, V> opsForValue(RedisSerializationContext<K, V> var1);

    public ReactiveZSetOperations<K, V> opsForZSet();

    public <K, V> ReactiveZSetOperations<K, V> opsForZSet(RedisSerializationContext<K, V> var1);

    public RedisSerializationContext<K, V> getSerializationContext();
}

