/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.core;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.dsl.core.EndpointSpec;
import org.springframework.integration.dsl.transaction.TransactionInterceptorBuilder;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.messaging.MessageHandler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public abstract class ConsumerEndpointSpec<S extends ConsumerEndpointSpec<S, H>, H extends MessageHandler>
extends EndpointSpec<S, ConsumerEndpointFactoryBean, H> {
    protected final List<Advice> adviceChain = new LinkedList<Advice>();

    protected ConsumerEndpointSpec(H messageHandler) {
        super(messageHandler);
        if (messageHandler != null) {
            ((ConsumerEndpointFactoryBean)this.endpointFactoryBean).setHandler(messageHandler);
        }
        ((ConsumerEndpointFactoryBean)this.endpointFactoryBean).setAdviceChain(this.adviceChain);
        if (messageHandler instanceof AbstractReplyProducingMessageHandler) {
            ((AbstractReplyProducingMessageHandler)messageHandler).setAdviceChain(this.adviceChain);
        }
    }

    @Override
    public S phase(int phase) {
        ((ConsumerEndpointFactoryBean)this.endpointFactoryBean).setPhase(phase);
        return (S)((ConsumerEndpointSpec)this._this());
    }

    @Override
    public S autoStartup(boolean autoStartup) {
        ((ConsumerEndpointFactoryBean)this.endpointFactoryBean).setAutoStartup(Boolean.valueOf(autoStartup));
        return (S)((ConsumerEndpointSpec)this._this());
    }

    @Override
    public S poller(PollerMetadata pollerMetadata) {
        ((ConsumerEndpointFactoryBean)this.endpointFactoryBean).setPollerMetadata(pollerMetadata);
        return (S)((ConsumerEndpointSpec)this._this());
    }

    public S advice(Advice ... advice) {
        this.adviceChain.addAll(Arrays.asList(advice));
        return (S)((ConsumerEndpointSpec)this._this());
    }

    public S transactional(PlatformTransactionManager transactionManager) {
        return this.transactional(transactionManager, false);
    }

    public S transactional(PlatformTransactionManager transactionManager, boolean handleMessageAdvice) {
        return this.transactional(new TransactionInterceptorBuilder(handleMessageAdvice).transactionManager(transactionManager).build());
    }

    public S transactional(TransactionInterceptor transactionInterceptor) {
        return this.advice(new Advice[]{transactionInterceptor});
    }

    public S transactional() {
        return this.transactional(false);
    }

    public S transactional(boolean handleMessageAdvice) {
        TransactionInterceptor transactionInterceptor = new TransactionInterceptorBuilder(handleMessageAdvice).build();
        this.componentToRegister.add(transactionInterceptor);
        return this.transactional(transactionInterceptor);
    }

    public S requiresReply(boolean requiresReply) {
        this.assertHandler();
        if (this.handler instanceof AbstractReplyProducingMessageHandler) {
            ((AbstractReplyProducingMessageHandler)this.handler).setRequiresReply(requiresReply);
        } else {
            this.logger.warn((Object)"'requiresReply' can be applied only for AbstractReplyProducingMessageHandler");
        }
        return (S)((ConsumerEndpointSpec)this._this());
    }

    public S sendTimeout(long sendTimeout) {
        this.assertHandler();
        if (this.handler instanceof AbstractReplyProducingMessageHandler) {
            ((AbstractReplyProducingMessageHandler)this.handler).setSendTimeout(sendTimeout);
        } else {
            this.logger.warn((Object)"'sendTimeout' can be applied only for AbstractReplyProducingMessageHandler");
        }
        return (S)((ConsumerEndpointSpec)this._this());
    }

    public S order(int order) {
        this.assertHandler();
        if (this.handler instanceof AbstractMessageHandler) {
            ((AbstractMessageHandler)this.handler).setOrder(order);
        } else {
            this.logger.warn((Object)"'order' can be applied only for AbstractMessageHandler");
        }
        return (S)((ConsumerEndpointSpec)this._this());
    }

    public S async(boolean async) {
        this.assertHandler();
        if (this.handler instanceof AbstractReplyProducingMessageHandler) {
            ((AbstractReplyProducingMessageHandler)this.handler).setAsync(async);
        } else {
            this.logger.warn((Object)"'async' can be applied only for AbstractReplyProducingMessageHandler");
        }
        return (S)((ConsumerEndpointSpec)this._this());
    }
}

