/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.savedrequest;

import java.net.URI;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.web.server.savedrequest.ServerRequestCache;
import org.springframework.security.web.server.util.matcher.AndServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.MediaTypeServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.NegatedServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public class WebSessionServerRequestCache
implements ServerRequestCache {
    private static final String DEFAULT_SAVED_REQUEST_ATTR = "SPRING_SECURITY_SAVED_REQUEST";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String sessionAttrName = "SPRING_SECURITY_SAVED_REQUEST";
    private ServerWebExchangeMatcher saveRequestMatcher = WebSessionServerRequestCache.createDefaultRequestMacher();

    public void setSaveRequestMatcher(ServerWebExchangeMatcher saveRequestMatcher) {
        Assert.notNull((Object)saveRequestMatcher, (String)"saveRequestMatcher cannot be null");
        this.saveRequestMatcher = saveRequestMatcher;
    }

    @Override
    public Mono<Void> saveRequest(ServerWebExchange exchange) {
        return this.saveRequestMatcher.matches(exchange).filter(m -> m.isMatch()).flatMap(m -> exchange.getSession()).map(WebSession::getAttributes).doOnNext(attrs -> attrs.put(this.sessionAttrName, WebSessionServerRequestCache.pathInApplication(exchange.getRequest()))).then();
    }

    @Override
    public Mono<URI> getRedirectUri(ServerWebExchange exchange) {
        return exchange.getSession().flatMap(session -> Mono.justOrEmpty((Object)session.getAttribute(this.sessionAttrName))).map(URI::create);
    }

    @Override
    public Mono<ServerHttpRequest> removeMatchingRequest(ServerWebExchange exchange) {
        return exchange.getSession().map(WebSession::getAttributes).filter(attributes -> attributes.remove(this.sessionAttrName, WebSessionServerRequestCache.pathInApplication(exchange.getRequest()))).map(attributes -> exchange.getRequest());
    }

    private static String pathInApplication(ServerHttpRequest request) {
        String path = request.getPath().pathWithinApplication().value();
        String query = request.getURI().getRawQuery();
        return path + (query != null ? "?" + query : "");
    }

    private static ServerWebExchangeMatcher createDefaultRequestMacher() {
        ServerWebExchangeMatcher get = ServerWebExchangeMatchers.pathMatchers(HttpMethod.GET, "/**");
        NegatedServerWebExchangeMatcher notFavicon = new NegatedServerWebExchangeMatcher(ServerWebExchangeMatchers.pathMatchers("/favicon.*"));
        MediaTypeServerWebExchangeMatcher html = new MediaTypeServerWebExchangeMatcher(MediaType.TEXT_HTML);
        html.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        return new AndServerWebExchangeMatcher(get, notFavicon, html);
    }
}

