/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.reportng;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.testng.IClass;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.xml.XmlSuite;
import org.uncommons.reportng.AbstractReporter;
import org.uncommons.reportng.ReportNGException;

public class HTMLReporter
extends AbstractReporter {
    private static final String ONLY_FAILURES_PROPERTY = "org.uncommons.reportng.failures-only";
    private static final String TEMPLATES_PATH = "templates/html/";
    private static final String HTML_EXTENSION = ".html";
    private static final String FTL_EXTENSION = ".ftl";
    private static final String INDEX_FILE = "index";
    private static final String GROUPS_FILE = "groups";
    private static final String RESULTS_FILE = "results";
    private static final String OUTPUT_FILE = "output";
    private static final String CUSTOM_STYLE_FILE = "custom.css";
    private static final String SUITE_KEY = "suite";
    private static final String SUITES_KEY = "suites";
    private static final String GROUPS_KEY = "groups";
    private static final String RESULT_KEY = "result";
    private static final String FAILED_CONFIG_KEY = "failedConfigurations";
    private static final String SKIPPED_CONFIG_KEY = "skippedConfigurations";
    private static final String FAILED_TESTS_KEY = "failedTests";
    private static final String SKIPPED_TESTS_KEY = "skippedTests";
    private static final String PASSED_TESTS_KEY = "passedTests";
    private static final String ONLY_FAILURES_KEY = "onlyReportFailures";
    private static final String REPORT_DIRECTORY = "html";
    private static final Comparator<ITestNGMethod> METHOD_COMPARATOR = Comparator.comparing(method -> method.getRealClass().getName()).thenComparing(ITestNGMethod::getMethodName);
    private static final Comparator<ITestResult> RESULT_COMPARATOR = Comparator.comparing(ITestResult::getName);
    private static final Comparator<IClass> CLASS_COMPARATOR = Comparator.comparing(IClass::getName);

    public HTMLReporter() {
        super(TEMPLATES_PATH);
    }

    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectoryName) {
        this.removeEmptyDirectories(new File(outputDirectoryName));
        boolean onlyFailures = System.getProperty(ONLY_FAILURES_PROPERTY, "false").equals("true");
        File outputDirectory = new File(outputDirectoryName, REPORT_DIRECTORY);
        outputDirectory.mkdirs();
        try {
            this.createSuiteList(suites, outputDirectory, onlyFailures);
            this.createGroups(suites, outputDirectory);
            this.createResults(suites, outputDirectory, onlyFailures);
            this.createLog(outputDirectory, onlyFailures);
            this.copyResources(outputDirectory);
        }
        catch (Exception ex) {
            throw new ReportNGException("Failed generating HTML report", ex);
        }
    }

    private void createSuiteList(List<ISuite> suites, File outputDirectory, boolean onlyFailures) throws Exception {
        Map<String, Object> context = this.createContext();
        context.put(SUITES_KEY, suites);
        context.put(ONLY_FAILURES_KEY, onlyFailures);
        this.generateFile(new File(outputDirectory, "index.html"), "index.ftl", context);
    }

    private void createResults(List<ISuite> suites, File outputDirectory, boolean onlyShowFailures) throws IOException, TemplateException {
        int i = 0;
        for (ISuite suite : suites) {
            int j = 0;
            for (ISuiteResult result : suite.getResults().values()) {
                boolean failuresExist;
                boolean bl = failuresExist = result.getTestContext().getFailedTests().size() > 0 || result.getTestContext().getFailedConfigurations().size() > 0;
                if (!onlyShowFailures || failuresExist) {
                    Map<String, Object> context = this.createContext();
                    context.put(RESULT_KEY, result);
                    context.put(FAILED_CONFIG_KEY, this.sortByTestClass(result.getTestContext().getFailedConfigurations()));
                    context.put(SKIPPED_CONFIG_KEY, this.sortByTestClass(result.getTestContext().getSkippedConfigurations()));
                    context.put(FAILED_TESTS_KEY, this.sortByTestClass(result.getTestContext().getFailedTests()));
                    context.put(SKIPPED_TESTS_KEY, this.sortByTestClass(result.getTestContext().getSkippedTests()));
                    context.put(PASSED_TESTS_KEY, this.sortByTestClass(result.getTestContext().getPassedTests()));
                    String fileName = String.format("suite%d_test%d_%s", i, j, "results.html");
                    this.generateFile(new File(outputDirectory, fileName), "results.ftl", context);
                }
                ++j;
            }
            ++i;
        }
    }

    private SortedMap<IClass, List<ITestResult>> sortByTestClass(IResultMap results) {
        TreeMap<IClass, List<ITestResult>> sortedResults = new TreeMap<IClass, List<ITestResult>>(CLASS_COMPARATOR);
        for (ITestResult result : results.getAllResults()) {
            List resultsForClass = sortedResults.computeIfAbsent(result.getTestClass(), k -> new ArrayList());
            int index = Collections.binarySearch(resultsForClass, result, RESULT_COMPARATOR);
            if (index < 0) {
                index = Math.abs(index + 1);
            }
            resultsForClass.add(index, result);
        }
        return sortedResults;
    }

    private void createGroups(List<ISuite> suites, File outputDirectory) throws IOException, TemplateException {
        int index = 0;
        for (ISuite suite : suites) {
            SortedMap<String, SortedSet<ITestNGMethod>> groups = this.sortGroups(suite.getMethodsByGroups());
            if (!groups.isEmpty()) {
                Map<String, Object> context = this.createContext();
                context.put(SUITE_KEY, suite);
                context.put("groups", groups);
                String fileName = String.format("suite%d_%s", index, "groups.html");
                this.generateFile(new File(outputDirectory, fileName), "groups.ftl", context);
            }
            ++index;
        }
    }

    private SortedMap<String, SortedSet<ITestNGMethod>> sortGroups(Map<String, Collection<ITestNGMethod>> groups) {
        TreeMap<String, SortedSet<ITestNGMethod>> sortedGroups = new TreeMap<String, SortedSet<ITestNGMethod>>();
        for (Map.Entry<String, Collection<ITestNGMethod>> entry : groups.entrySet()) {
            TreeSet<ITestNGMethod> methods = new TreeSet<ITestNGMethod>(METHOD_COMPARATOR);
            methods.addAll(entry.getValue());
            sortedGroups.put(entry.getKey(), methods);
        }
        return sortedGroups;
    }

    private void createLog(File outputDirectory, boolean onlyFailures) throws IOException, TemplateException {
        if (!Reporter.getOutput().isEmpty()) {
            Map<String, Object> context = this.createContext();
            context.put(ONLY_FAILURES_KEY, onlyFailures);
            this.generateFile(new File(outputDirectory, "output.html"), "output.ftl", context);
        }
    }

    private void copyResources(File outputDirectory) throws IOException {
        this.copyClasspathResource(outputDirectory, "reportng.css", "reportng.css");
        this.copyClasspathResource(outputDirectory, "reportng.js", "reportng.js");
        File customStylesheet = META.getStylesheetPath();
        if (customStylesheet != null) {
            if (customStylesheet.exists()) {
                this.copyFile(outputDirectory, customStylesheet, CUSTOM_STYLE_FILE);
            } else {
                InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(customStylesheet.getPath());
                if (stream != null) {
                    this.copyStream(outputDirectory, stream, CUSTOM_STYLE_FILE);
                }
            }
        }
    }
}

