/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.reportng;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IInvokedMethod;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SkipException;

public class ReportNGUtils {
    private static final NumberFormat DURATION_FORMAT = new DecimalFormat("#0.000");
    private static final NumberFormat PERCENTAGE_FORMAT = new DecimalFormat("#0.00%");

    private long getDuration(Set<ITestResult> results) {
        long duration = 0L;
        for (ITestResult result : results) {
            duration += result.getEndMillis() - result.getStartMillis();
        }
        return duration;
    }

    public long getDuration(ITestContext context) {
        long duration = this.getDuration(context.getPassedConfigurations().getAllResults());
        duration += this.getDuration(context.getPassedTests().getAllResults());
        duration += this.getDuration(context.getSkippedConfigurations().getAllResults());
        duration += this.getDuration(context.getSkippedTests().getAllResults());
        duration += this.getDuration(context.getFailedConfigurations().getAllResults());
        return duration += this.getDuration(context.getFailedTests().getAllResults());
    }

    public String formatDuration(long startMillis, long endMillis) {
        long elapsed = endMillis - startMillis;
        return this.formatDuration(elapsed);
    }

    public String formatDuration(long elapsed) {
        double seconds = (double)elapsed / 1000.0;
        return DURATION_FORMAT.format(seconds);
    }

    public List<Throwable> getCauses(Throwable t) {
        LinkedList<Throwable> causes = new LinkedList<Throwable>();
        Throwable next = t;
        while (next.getCause() != null) {
            next = next.getCause();
            causes.add(next);
        }
        return causes;
    }

    public List<String> getTestOutput(ITestResult result) {
        return Reporter.getOutput((ITestResult)result);
    }

    public List<String> getAllOutput() {
        return Reporter.getOutput();
    }

    public boolean hasArguments(ITestResult result) {
        return result.getParameters().length > 0;
    }

    public String getArguments(ITestResult result) {
        Object[] arguments = result.getParameters();
        ArrayList<String> argumentStrings = new ArrayList<String>(arguments.length);
        for (Object argument : arguments) {
            argumentStrings.add(this.renderArgument(argument));
        }
        return this.commaSeparate(argumentStrings);
    }

    private String renderArgument(Object argument) {
        if (argument == null) {
            return "null";
        }
        if (argument instanceof String) {
            return "\"" + argument + "\"";
        }
        if (argument instanceof Character) {
            return "'" + argument + "'";
        }
        return argument.toString();
    }

    private String commaSeparate(Collection<String> strings) {
        StringBuilder buffer = new StringBuilder();
        Iterator<String> iterator = strings.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            buffer.append(string);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public boolean hasDependentGroups(ITestResult result) {
        return result.getMethod().getGroupsDependedUpon().length > 0;
    }

    public String getDependentGroups(ITestResult result) {
        String[] groups = result.getMethod().getGroupsDependedUpon();
        return this.commaSeparate(Arrays.asList(groups));
    }

    public boolean hasDependentMethods(ITestResult result) {
        return result.getMethod().getMethodsDependedUpon().length > 0;
    }

    public String getDependentMethods(ITestResult result) {
        String[] methods = result.getMethod().getMethodsDependedUpon();
        return this.commaSeparate(Arrays.asList(methods));
    }

    public boolean hasSkipException(ITestResult result) {
        return result.getThrowable() instanceof SkipException;
    }

    public String getSkipExceptionMessage(ITestResult result) {
        return this.hasSkipException(result) ? result.getThrowable().getMessage() : "";
    }

    public boolean hasGroups(ISuite suite) {
        return !suite.getMethodsByGroups().isEmpty();
    }

    public String escapeString(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            buffer.append(this.escapeChar(s.charAt(i)));
        }
        return buffer.toString();
    }

    private String escapeChar(char character) {
        switch (character) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
            case '&': {
                return "&amp;";
            }
        }
        return String.valueOf(character);
    }

    public String escapeHTMLString(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        block4: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case ' ': {
                    char nextCh = i + 1 < s.length() ? s.charAt(i + 1) : (char)'\u0000';
                    buffer.append(nextCh == ' ' ? "&nbsp;" : " ");
                    continue block4;
                }
                case '\n': {
                    buffer.append("<br/>\n");
                    continue block4;
                }
                default: {
                    buffer.append(this.escapeChar(ch));
                }
            }
        }
        return buffer.toString();
    }

    public String stripThreadName(String threadId) {
        if (threadId == null) {
            return null;
        }
        int index = threadId.lastIndexOf(64);
        return index >= 0 ? threadId.substring(0, index) : threadId;
    }

    public long getStartTime(List<IInvokedMethod> methods) {
        long startTime = System.currentTimeMillis();
        for (IInvokedMethod method : methods) {
            startTime = Math.min(startTime, method.getDate());
        }
        return startTime;
    }

    public long getEndTime(ISuite suite, IInvokedMethod method, List<IInvokedMethod> methods) {
        boolean found = false;
        for (IInvokedMethod m : methods) {
            if (m == method) {
                found = true;
                continue;
            }
            if (!found || !m.getTestMethod().getId().equals(method.getTestMethod().getId())) continue;
            return m.getDate();
        }
        return this.getEndTime(suite, method);
    }

    private long getEndTime(ISuite suite, IInvokedMethod method) {
        for (Map.Entry entry : suite.getResults().entrySet()) {
            ITestContext testContext = ((ISuiteResult)entry.getValue()).getTestContext();
            for (ITestNGMethod m : testContext.getAllTestMethods()) {
                if (method.getTestMethod() != m) continue;
                return testContext.getEndDate().getTime();
            }
            if (ReportNGUtils.hasMethod(testContext.getPassedConfigurations(), method)) {
                return testContext.getEndDate().getTime();
            }
            if (!ReportNGUtils.hasMethod(testContext.getFailedConfigurations(), method)) continue;
            return testContext.getEndDate().getTime();
        }
        throw new IllegalStateException("Could not find matching end time.");
    }

    private static boolean hasMethod(IResultMap resultMap, IInvokedMethod method) {
        for (ITestNGMethod m : resultMap.getAllMethods()) {
            if (method.getTestMethod() != m) continue;
            return true;
        }
        return false;
    }

    public String formatPercentage(int numerator, int denominator) {
        return PERCENTAGE_FORMAT.format((double)numerator / (double)denominator);
    }
}

