/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.scheduler;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.server.core.scheduler.InstanceStatusCheckService;
import tech.powerjob.server.core.scheduler.PowerScheduleService;

@Service
public class CoreScheduleTaskManager
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(CoreScheduleTaskManager.class);
    private final PowerScheduleService powerScheduleService;
    private final InstanceStatusCheckService instanceStatusCheckService;
    private final List<Thread> coreThreadContainer = new ArrayList<Thread>();

    public void afterPropertiesSet() {
        this.coreThreadContainer.add(new Thread((Runnable)new LoopRunnable("ScheduleCronJob", 15000L, () -> this.powerScheduleService.scheduleNormalJob(TimeExpressionType.CRON)), "Thread-ScheduleCronJob"));
        this.coreThreadContainer.add(new Thread((Runnable)new LoopRunnable("ScheduleDailyTimeIntervalJob", 15000L, () -> this.powerScheduleService.scheduleNormalJob(TimeExpressionType.DAILY_TIME_INTERVAL)), "Thread-ScheduleDailyTimeIntervalJob"));
        this.coreThreadContainer.add(new Thread((Runnable)new LoopRunnable("ScheduleCronWorkflow", 15000L, this.powerScheduleService::scheduleCronWorkflow), "Thread-ScheduleCronWorkflow"));
        this.coreThreadContainer.add(new Thread((Runnable)new LoopRunnable("ScheduleFrequentJob", 15000L, this.powerScheduleService::scheduleFrequentJob), "Thread-ScheduleFrequentJob"));
        this.coreThreadContainer.add(new Thread((Runnable)new LoopRunnable("CleanWorkerData", 15000L, this.powerScheduleService::cleanData), "Thread-CleanWorkerData"));
        this.coreThreadContainer.add(new Thread((Runnable)new LoopRunnable("CheckRunningInstance", 10000L, this.instanceStatusCheckService::checkRunningInstance), "Thread-CheckRunningInstance"));
        this.coreThreadContainer.add(new Thread((Runnable)new LoopRunnable("CheckWaitingDispatchInstance", 10000L, this.instanceStatusCheckService::checkWaitingDispatchInstance), "Thread-CheckWaitingDispatchInstance"));
        this.coreThreadContainer.add(new Thread((Runnable)new LoopRunnable("CheckWaitingWorkerReceiveInstance", 10000L, this.instanceStatusCheckService::checkWaitingWorkerReceiveInstance), "Thread-CheckWaitingWorkerReceiveInstance"));
        this.coreThreadContainer.add(new Thread((Runnable)new LoopRunnable("CheckWorkflowInstance", 10000L, this.instanceStatusCheckService::checkWorkflowInstance), "Thread-CheckWorkflowInstance"));
        this.coreThreadContainer.forEach(Thread::start);
    }

    public void destroy() {
        this.coreThreadContainer.forEach(Thread::interrupt);
    }

    public CoreScheduleTaskManager(PowerScheduleService powerScheduleService, InstanceStatusCheckService instanceStatusCheckService) {
        this.powerScheduleService = powerScheduleService;
        this.instanceStatusCheckService = instanceStatusCheckService;
    }

    private static class LoopRunnable
    implements Runnable {
        private final String taskName;
        private final Long runningInterval;
        private final Runnable innerRunnable;

        @Override
        public void run() {
            log.info("start task : {}.", (Object)this.taskName);
            while (true) {
                try {
                    while (true) {
                        this.innerRunnable.run();
                        Thread.sleep(this.runningInterval);
                    }
                }
                catch (InterruptedException e) {
                    log.warn("[{}] task has been interrupted!", (Object)this.taskName, (Object)e);
                }
                catch (Exception e) {
                    log.error("[{}] task failed!", (Object)this.taskName, (Object)e);
                    continue;
                }
                break;
            }
        }

        public LoopRunnable(String taskName, Long runningInterval, Runnable innerRunnable) {
            this.taskName = taskName;
            this.runningInterval = runningInterval;
            this.innerRunnable = innerRunnable;
        }
    }
}

