/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.workflow.hanlder.impl;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.enums.WorkflowNodeType;
import tech.powerjob.common.model.PEWorkflowDAG;
import tech.powerjob.server.common.utils.SpringUtils;
import tech.powerjob.server.core.DispatchService;
import tech.powerjob.server.core.instance.InstanceService;
import tech.powerjob.server.core.workflow.hanlder.TaskNodeHandler;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;
import tech.powerjob.server.persistence.remote.model.WorkflowInstanceInfoDO;
import tech.powerjob.server.persistence.remote.repository.JobInfoRepository;

@Component
public class JobNodeHandler
implements TaskNodeHandler {
    private static final Logger log = LoggerFactory.getLogger(JobNodeHandler.class);
    private final JobInfoRepository jobInfoRepository;

    @Override
    public void createTaskInstance(PEWorkflowDAG.Node node, PEWorkflowDAG dag, WorkflowInstanceInfoDO wfInstanceInfo) {
        Long instanceId = ((InstanceService)SpringUtils.getBean(InstanceService.class)).create(node.getJobId(), wfInstanceInfo.getAppId(), node.getNodeParams(), wfInstanceInfo.getWfContext(), wfInstanceInfo.getWfInstanceId(), System.currentTimeMillis()).getInstanceId();
        node.setInstanceId(instanceId);
        node.setStatus(Integer.valueOf(InstanceStatus.RUNNING.getV()));
        log.info("[Workflow-{}|{}] create readyNode(JOB) instance(nodeId={},jobId={},instanceId={}) successfully~", new Object[]{wfInstanceInfo.getWorkflowId(), wfInstanceInfo.getWfInstanceId(), node.getNodeId(), node.getJobId(), instanceId});
    }

    @Override
    public void startTaskInstance(PEWorkflowDAG.Node node) {
        JobInfoDO jobInfo = this.jobInfoRepository.findById((Object)node.getJobId()).orElseGet(JobInfoDO::new);
        jobInfo.setTimeExpressionType(Integer.valueOf(TimeExpressionType.WORKFLOW.getV()));
        ((DispatchService)SpringUtils.getBean(DispatchService.class)).dispatch(jobInfo, node.getInstanceId(), Optional.empty(), Optional.empty());
    }

    @Override
    public WorkflowNodeType matchingType() {
        return WorkflowNodeType.JOB;
    }

    public JobNodeHandler(JobInfoRepository jobInfoRepository) {
        this.jobInfoRepository = jobInfoRepository;
    }
}

