/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.background;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.enhance.SafeRunnable;
import tech.powerjob.common.enums.LogLevel;
import tech.powerjob.common.model.InstanceLogContent;
import tech.powerjob.common.request.WorkerLogReportReq;
import tech.powerjob.remote.framework.transporter.Transporter;
import tech.powerjob.worker.background.discovery.ServerDiscoveryService;
import tech.powerjob.worker.common.utils.TransportUtils;

public class OmsLogHandler {
    private static final Logger log = LoggerFactory.getLogger(OmsLogHandler.class);
    private final String workerAddress;
    private final Transporter transporter;
    private final ServerDiscoveryService serverDiscoveryService;
    public final Runnable logSubmitter = new LogSubmitter();
    private final Lock reportLock = new ReentrantLock();
    private final BlockingQueue<InstanceLogContent> logQueue = Queues.newLinkedBlockingQueue((int)10240);
    private static final int BATCH_SIZE = 20;
    private static final int REPORT_SIZE = 1024;

    public OmsLogHandler(String workerAddress, Transporter transporter, ServerDiscoveryService serverDiscoveryService) {
        this.workerAddress = workerAddress;
        this.transporter = transporter;
        this.serverDiscoveryService = serverDiscoveryService;
    }

    public void submitLog(long instanceId, LogLevel logLevel, String logContent) {
        InstanceLogContent tuple;
        boolean offerRet;
        if (this.logQueue.size() > 1024) {
            new Thread(this.logSubmitter).start();
        }
        if (!(offerRet = this.logQueue.offer(tuple = new InstanceLogContent(instanceId, System.currentTimeMillis(), logLevel.getV(), logContent)))) {
            log.warn("[OmsLogHandler] [{}] submit log failed, maybe your log speed is too fast!", (Object)instanceId);
        }
    }

    private class LogSubmitter
    extends SafeRunnable {
        private LogSubmitter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run0() {
            boolean lockResult = OmsLogHandler.this.reportLock.tryLock();
            if (!lockResult) {
                return;
            }
            try {
                String currentServerAddress = OmsLogHandler.this.serverDiscoveryService.getCurrentServerAddress();
                if (StringUtils.isEmpty((CharSequence)currentServerAddress)) {
                    if (!OmsLogHandler.this.logQueue.isEmpty()) {
                        OmsLogHandler.this.logQueue.clear();
                        log.warn("[OmsLogHandler] because there is no available server to report logs which leads to queue accumulation, oms discarded all logs.");
                    }
                    return;
                }
                LinkedList logs = Lists.newLinkedList();
                while (!OmsLogHandler.this.logQueue.isEmpty()) {
                    try {
                        InstanceLogContent logContent = (InstanceLogContent)OmsLogHandler.this.logQueue.poll(100L, TimeUnit.MILLISECONDS);
                        logs.add(logContent);
                        if (logs.size() < 20) continue;
                        WorkerLogReportReq req = new WorkerLogReportReq(OmsLogHandler.this.workerAddress, (List)Lists.newLinkedList((Iterable)logs));
                        TransportUtils.reportLogs(req, currentServerAddress, OmsLogHandler.this.transporter);
                        logs.clear();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                        break;
                    }
                }
                if (!logs.isEmpty()) {
                    WorkerLogReportReq req = new WorkerLogReportReq(OmsLogHandler.this.workerAddress, (List)logs);
                    TransportUtils.reportLogs(req, currentServerAddress, OmsLogHandler.this.transporter);
                }
            }
            finally {
                OmsLogHandler.this.reportLock.unlock();
            }
        }
    }
}

