/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class PoiReflectorUtil {
    private static final Map<Class<?>, PoiReflectorUtil> CACHE_REFLECTOR = new ConcurrentHashMap();
    private Map<String, Method> getMethods = new HashMap<String, Method>();
    private Map<String, Method> setMethods = new HashMap<String, Method>();
    private List<Field> fieldList = new ArrayList<Field>();
    private Class<?> type;

    private PoiReflectorUtil(Class<?> clazz) {
        this.addGetMethods(clazz);
        this.addFields(clazz);
        this.addSetMethods(clazz);
    }

    public static PoiReflectorUtil forClass(Class<?> clazz) {
        return new PoiReflectorUtil(clazz);
    }

    public static PoiReflectorUtil fromCache(Class<?> clazz) {
        if (!CACHE_REFLECTOR.containsKey(clazz)) {
            CACHE_REFLECTOR.put(clazz, new PoiReflectorUtil(clazz));
        }
        return CACHE_REFLECTOR.get(clazz);
    }

    private void addGetMethods(Class<?> cls) {
        Method[] methods;
        HashMap<String, List<Method>> conflictingGetters = new HashMap<String, List<Method>>();
        for (Method method : methods = this.getClassMethods(cls)) {
            String name = method.getName();
            if (name.startsWith("get") && name.length() > 3) {
                if (method.getParameterTypes().length != 0) continue;
                name = PoiReflectorUtil.methodToProperty(name);
                this.addMethodConflict(conflictingGetters, name, method);
                continue;
            }
            if (!name.startsWith("is") || name.length() <= 2 || method.getParameterTypes().length != 0) continue;
            name = PoiReflectorUtil.methodToProperty(name);
            this.addMethodConflict(conflictingGetters, name, method);
        }
        this.resolveGetterConflicts(conflictingGetters);
    }

    private void resolveGetterConflicts(Map<String, List<Method>> conflictingGetters) {
        for (String propName : conflictingGetters.keySet()) {
            List<Method> getters = conflictingGetters.get(propName);
            Iterator<Method> iterator = getters.iterator();
            Method firstMethod = iterator.next();
            if (getters.size() == 1) {
                this.addGetMethod(propName, firstMethod);
                continue;
            }
            Method getter = firstMethod;
            Class<?> getterType = firstMethod.getReturnType();
            while (iterator.hasNext()) {
                Method method = iterator.next();
                Class<?> methodType = method.getReturnType();
                if (methodType.equals(getterType)) {
                    throw new RuntimeException("Illegal overloaded getter method with ambiguous type for property " + propName + " in class " + firstMethod.getDeclaringClass() + ".  This breaks the JavaBeans " + "specification and can cause unpredicatble results.");
                }
                if (methodType.isAssignableFrom(getterType)) continue;
                if (getterType.isAssignableFrom(methodType)) {
                    getter = method;
                    getterType = methodType;
                    continue;
                }
                throw new RuntimeException("Illegal overloaded getter method with ambiguous type for property " + propName + " in class " + firstMethod.getDeclaringClass() + ".  This breaks the JavaBeans " + "specification and can cause unpredicatble results.");
            }
            this.addGetMethod(propName, getter);
        }
    }

    private void addGetMethod(String name, Method method) {
        if (this.isValidPropertyName(name)) {
            this.getMethods.put(name, method);
        }
    }

    private void addSetMethods(Class<?> cls) {
        Method[] methods;
        HashMap<String, List<Method>> conflictingSetters = new HashMap<String, List<Method>>();
        for (Method method : methods = this.getClassMethods(cls)) {
            String name = method.getName();
            if (!name.startsWith("set") || name.length() <= 3 || method.getParameterTypes().length != 1) continue;
            name = PoiReflectorUtil.methodToProperty(name);
            this.addMethodConflict(conflictingSetters, name, method);
        }
        this.resolveSetterConflicts(conflictingSetters);
    }

    private static String methodToProperty(String name) {
        if (name.startsWith("is")) {
            name = name.substring(2);
        } else if (name.startsWith("get") || name.startsWith("set")) {
            name = name.substring(3);
        } else {
            throw new RuntimeException("Error parsing property name '" + name + "'.  Didn't start with 'is', 'get' or 'set'.");
        }
        if (name.length() == 1 || name.length() > 1 && !Character.isUpperCase(name.charAt(1))) {
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }

    private void addMethodConflict(Map<String, List<Method>> conflictingMethods, String name, Method method) {
        List<Method> list = conflictingMethods.get(name);
        if (list == null) {
            list = new ArrayList<Method>();
            conflictingMethods.put(name, list);
        }
        list.add(method);
    }

    private void resolveSetterConflicts(Map<String, List<Method>> conflictingSetters) {
        for (String propName : conflictingSetters.keySet()) {
            List<Method> setters = conflictingSetters.get(propName);
            Method firstMethod = setters.get(0);
            if (setters.size() == 1) {
                this.addSetMethod(propName, firstMethod);
                continue;
            }
            Iterator<Method> methods = setters.iterator();
            Method setter = null;
            while (methods.hasNext()) {
                Method method = methods.next();
                if (method.getParameterTypes().length != 1) continue;
                setter = method;
                break;
            }
            if (setter == null) {
                throw new RuntimeException("Illegal overloaded setter method with ambiguous type for property " + propName + " in class " + firstMethod.getDeclaringClass() + ".  This breaks the JavaBeans " + "specification and can cause unpredicatble results.");
            }
            this.addSetMethod(propName, setter);
        }
    }

    private void addSetMethod(String name, Method method) {
        if (this.isValidPropertyName(name)) {
            this.setMethods.put(name, method);
        }
    }

    private void addFields(Class<?> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (this.canAccessPrivateMethods()) {
                try {
                    field.setAccessible(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!field.isAccessible() || field.getName().equalsIgnoreCase("serialVersionUID")) continue;
            this.fieldList.add(field);
        }
        if (clazz.getSuperclass() != null) {
            this.addFields(clazz.getSuperclass());
        }
    }

    private boolean isValidPropertyName(String name) {
        return !name.startsWith("$") && !"serialVersionUID".equals(name) && !"class".equals(name);
    }

    private Method[] getClassMethods(Class<?> cls) {
        HashMap<String, Method> uniqueMethods = new HashMap<String, Method>();
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Class<?>[] interfaces;
            this.addUniqueMethods(uniqueMethods, currentClass.getDeclaredMethods());
            for (Class<?> anInterface : interfaces = currentClass.getInterfaces()) {
                this.addUniqueMethods(uniqueMethods, anInterface.getMethods());
            }
        }
        Collection methods = uniqueMethods.values();
        return methods.toArray(new Method[methods.size()]);
    }

    private void addUniqueMethods(HashMap<String, Method> uniqueMethods, Method[] methods) {
        for (Method currentMethod : methods) {
            String signature;
            if (currentMethod.isBridge() || uniqueMethods.containsKey(signature = this.getSignature(currentMethod))) continue;
            if (this.canAccessPrivateMethods()) {
                try {
                    currentMethod.setAccessible(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            uniqueMethods.put(signature, currentMethod);
        }
    }

    private String getSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        Class<?> returnType = method.getReturnType();
        if (returnType != null) {
            sb.append(returnType.getName()).append('#');
        }
        sb.append(method.getName());
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (i == 0) {
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(parameters[i].getName());
        }
        return sb.toString();
    }

    private boolean canAccessPrivateMethods() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (null != securityManager) {
                securityManager.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    public Method getGetMethod(String propertyName) {
        Method method = this.getMethods.get(propertyName);
        if (method == null) {
            throw new RuntimeException("There is no getter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return method;
    }

    public Method getSetMethod(String propertyName) {
        Method method = this.setMethods.get(propertyName);
        if (method == null) {
            throw new RuntimeException("There is no getter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return method;
    }

    public Object getValue(Object obj, String property) {
        Object value = null;
        Method m = this.getMethods.get(property);
        if (m != null) {
            try {
                value = m.invoke(obj, new Object[0]);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return value;
    }

    public boolean setValue(Object obj, String property, Object object) {
        Method m = this.setMethods.get(property);
        if (m != null) {
            try {
                m.invoke(obj, object);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public Map<String, Method> getGetMethods() {
        return this.getMethods;
    }

    public List<Field> getFieldList() {
        return this.fieldList;
    }
}

