/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.wrench.dynamic.config.center.domain.service;

import cn.bugstack.wrench.dynamic.config.center.config.DynamicConfigCenterAutoConfig;
import cn.bugstack.wrench.dynamic.config.center.config.DynamicConfigCenterAutoProperties;
import cn.bugstack.wrench.dynamic.config.center.domain.model.valobj.AttributeVO;
import cn.bugstack.wrench.dynamic.config.center.domain.service.IDynamicConfigCenterService;
import cn.bugstack.wrench.dynamic.config.center.types.annotations.DCCValue;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;

public class DynamicConfigCenterService
implements IDynamicConfigCenterService {
    private final Logger log = LoggerFactory.getLogger(DynamicConfigCenterAutoConfig.class);
    private final DynamicConfigCenterAutoProperties properties;
    private final RedissonClient redissonClient;
    private final Map<String, Object> dccBeanGroup = new ConcurrentHashMap<String, Object>();

    public DynamicConfigCenterService(DynamicConfigCenterAutoProperties properties, RedissonClient redissonClient) {
        this.properties = properties;
        this.redissonClient = redissonClient;
    }

    @Override
    public Object proxyObject(Object bean2) {
        Field[] fields;
        Class<?> targetBeanClass = bean2.getClass();
        Object targetBeanObject = bean2;
        if (AopUtils.isAopProxy(bean2)) {
            targetBeanClass = AopUtils.getTargetClass(bean2);
            targetBeanObject = AopProxyUtils.getSingletonTarget(bean2);
        }
        for (Field field : fields = targetBeanClass.getDeclaredFields()) {
            String defaultValue;
            if (!field.isAnnotationPresent(DCCValue.class)) continue;
            DCCValue dccValue = field.getAnnotation(DCCValue.class);
            String value = dccValue.value();
            if (StringUtils.isBlank(value)) {
                throw new RuntimeException(field.getName() + " @DCCValue is not config value config case \u300cisSwitch/isSwitch:1\u300d");
            }
            String[] splits = value.split(":");
            String key = this.properties.getKey(splits[0].trim());
            String setValue = defaultValue = splits.length == 2 ? splits[1] : null;
            try {
                if (StringUtils.isBlank(defaultValue)) {
                    throw new RuntimeException("dcc config error " + key + " is not null - \u8bf7\u914d\u7f6e\u9ed8\u8ba4\u503c\uff01");
                }
                RBucket<String> bucket = this.redissonClient.getBucket(key);
                boolean exists = bucket.isExists();
                if (!exists) {
                    bucket.set(defaultValue);
                } else {
                    setValue = (String)bucket.get();
                }
                field.setAccessible(true);
                field.set(targetBeanObject, setValue);
                field.setAccessible(false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.dccBeanGroup.put(key, targetBeanObject);
        }
        return bean2;
    }

    @Override
    public void adjustAttributeValue(AttributeVO attributeVO) {
        String key = this.properties.getKey(attributeVO.getAttribute());
        String value = attributeVO.getValue();
        RBucket<String> bucket = this.redissonClient.getBucket(key);
        boolean exists = bucket.isExists();
        if (!exists) {
            return;
        }
        bucket.set(attributeVO.getValue());
        Object objBean = this.dccBeanGroup.get(key);
        if (null == objBean) {
            return;
        }
        Class<?> objBeanClass = objBean.getClass();
        if (AopUtils.isAopProxy(objBean)) {
            objBeanClass = AopUtils.getTargetClass(objBean);
        }
        try {
            Field field = objBeanClass.getDeclaredField(attributeVO.getAttribute());
            field.setAccessible(true);
            field.set(objBean, value);
            field.setAccessible(false);
            this.log.info("DCC \u8282\u70b9\u76d1\u542c\uff0c\u52a8\u6001\u8bbe\u7f6e\u503c {} {}", (Object)key, (Object)value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

