/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointIdTimeToLivePropertyFunction;
import org.springframework.boot.actuate.endpoint.annotation.EndpointConverter;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.invoke.convert.ConversionServiceParameterValueMapper;
import org.springframework.boot.actuate.endpoint.invoker.cache.CachingOperationInvokerAdvisor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.env.Environment;

@AutoConfiguration
public class EndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ParameterValueMapper endpointOperationParameterMapper(@EndpointConverter ObjectProvider<Converter<?, ?>> converters, @EndpointConverter ObjectProvider<GenericConverter> genericConverters) {
        ConversionService conversionService = this.createConversionService(converters.orderedStream().collect(Collectors.toList()), genericConverters.orderedStream().collect(Collectors.toList()));
        return new ConversionServiceParameterValueMapper(conversionService);
    }

    private ConversionService createConversionService(List<Converter<?, ?>> converters, List<GenericConverter> genericConverters) {
        if (genericConverters.isEmpty() && converters.isEmpty()) {
            return ApplicationConversionService.getSharedInstance();
        }
        ApplicationConversionService conversionService = new ApplicationConversionService();
        converters.forEach(conversionService::addConverter);
        genericConverters.forEach(conversionService::addConverter);
        return conversionService;
    }

    @Bean
    @ConditionalOnMissingBean
    public CachingOperationInvokerAdvisor endpointCachingOperationInvokerAdvisor(Environment environment2) {
        return new CachingOperationInvokerAdvisor(new EndpointIdTimeToLivePropertyFunction(environment2));
    }
}

